#!/usr/bin/env bash

# Install script for the MQTT-CoAP-Exercise files
# (C) Copyright 2024, Lars Staalhagen, larst@dtu.dk

# Set WITHDOCS to "TRUE" if documentation for libcoap should be installed
WITHDOCS="FALSE"
if [ "${1}" = "--withdocs" ] ; then
  WITHDOCS="TRUE"
fi

# Check for root 
[ $(id -u) -ne 0 ] && echo "Script must be executed with sudo" && exit

# Download necessary supplementary software
echo "Downloading support software ... (MAY TAKE SOME TIME)"
apt-get update
apt-get -y install openvswitch-common openvswitch-switch doxygen
if [ "${WITHDOCS}" = "TRUE" ] ; then
  apt-get -y install asciidoc exuberant-ctags
fi

# Download MQTT software. Note that we also disable the autostart of the broker since we want
# to do it manually in this exercise. Also create directory in /run for the broker's PID-file
echo "Downloading MQTT software ..."
apt-get -y install mosquitto mosquitto-clients 
systemctl stop mosquitto.service
systemctl mask mosquitto.service
[ ! -d /run/mosquitto ] && mkdir -p /run/mosquitto && chown mosquitto: /run/mosquitto

# Download/install libcoap (can take several minutes)
echo "Downloading libcoap ... (MAY TAKE SOME TIME)"
git clone https://github.com/obgm/libcoap.git
cd libcoap
./autogen.sh
if [ "${WITHDOCS}" = "TRUE" ] ; then
  ./configure --with-documentation --with-examples
else
  ./configure --disable-manpages
fi
make
make install
cd ..
rm -rf libcoap

# Add some stuff to root's .bashrc for namespace naming and library path for coap-programs
if ! (grep -q -e "TAG:MQTTCOAPEXERCISE" /root/.bashrc) ; then
  cat root-bashrc-addition >> /root/.bashrc
fi
