#ifndef RBF_CLASSIFIER_H
#define RBF_CLASSIFIER_H

#define NUM_FEATURES 116

#define NUM_EXPLOIT_CLASSES 18

typedef struct _exploit_kit_data_entry {
   int precheck_fail;
   double mean[NUM_FEATURES];
   double var[NUM_FEATURES];
   double precheck[NUM_FEATURES];
} exploit_kit_data_entry;

// Family: caws_1, trained with 4 samples
exploit_kit_data_entry caws_1 = {
   .mean = {
      2.0000000000,      1.0000000000,      5.0000000000,
      1.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      1.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      3.0000000000,
      0.0000000000,      6.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      6.0000000000,      0.0000000000,
      1.0000000000,      85.0000000000,      0.0000000000,
      21.2500000000,      22.0000000000,      33.0000000000,
      72.2500000000,      117.0000000000,      117.0000000000,
      135.0000000000,      526.7500000000,      220.0000000000,
      90.5000000000,      5.2500000000,      494.2500000000,
      511.5000000000,      789.7500000000,      563.0000000000,
      521.5000000000,      546.7500000000,      491.2500000000,
      492.7500000000,      518.2500000000,      490.2500000000,
      509.0000000000,      13.0000000000,      78.0000000000,
      38.0000000000,      105.0000000000,      34.0000000000,
      2.0000000000,      32.0000000000,      471.5000000000,
      462.0000000000,      494.0000000000,      468.5000000000,
      509.2500000000,      488.0000000000,      468.0000000000,
      484.5000000000,      466.0000000000,      492.5000000000,
      463.2500000000,      454.7500000000,      469.2500000000,
      462.7500000000,      455.7500000000,      460.0000000000,
      497.7500000000,      489.7500000000,      502.2500000000,
      499.5000000000,      469.2500000000,      497.7500000000,
      488.2500000000,      477.2500000000,      481.5000000000,
      467.5000000000,      82.0000000000,      740.0000000000,
      82.0000000000,      12.0000000000,      1.2500000000,
      0.0000000000,      500.7500000000,      465.5000000000,
      520.0000000000,      494.7500000000,      526.2500000000,
      537.0000000000,      490.7500000000,      512.7500000000,
      540.2500000000,      493.5000000000,      529.7500000000,
      491.5000000000,      496.7500000000,      529.2500000000,
      502.2500000000,      507.2500000000,      467.7500000000,
      489.2500000000,      508.5000000000,      513.5000000000,
      462.5000000000,      458.7500000000,      472.7500000000,
      546.7500000000,      467.0000000000,      489.7500000000,
      30.0000000000,      12.0000000000,      30.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      3.0000000000,      0.0448140000,
      9.1875000000,      0.0448140000,      0.0448140000,
      99.1875000000,      0.0448140000,      0.0448140000,
      3072.0000000000,      450.1875000000,      16.0000000000,
      0.7500000000,      0.1875000000,      157.6875000000,
      61.2500000000,      623.6875000000,      198.5000000000,
      252.7500000000,      77.6875000000,      1813.1875000000,
      1292.1875000000,      23.1875000000,      89.1875000000,
      4.5000000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      3072.0000000000,      126.7500000000,
      192.0000000000,      3.0000000000,      60.7500000000,
      526.6875000000,      507.0000000000,      675.0000000000,
      6.7500000000,      300.0000000000,      90.7500000000,
      4.6875000000,      136.6875000000,      256.6875000000,
      744.1875000000,      841.6875000000,      12.0000000000,
      204.1875000000,      180.1875000000,      315.1875000000,
      6.7500000000,      157.6875000000,      99.1875000000,
      450.1875000000,      1111.6875000000,      18.7500000000,
      0.7500000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.1875000000,
      0.0448140000,      346.6875000000,      36.7500000000,
      108.0000000000,      180.1875000000,      1111.6875000000,
      12.0000000000,      31.6875000000,      136.6875000000,
      42.1875000000,      270.7500000000,      54.1875000000,
      468.7500000000,      99.1875000000,      99.1875000000,
      157.6875000000,      99.1875000000,      67.6875000000,
      450.1875000000,      216.7500000000,      1140.7500000000,
      720.7500000000,      1170.1875000000,      652.6875000000,
      4.6875000000,      12.0000000000,      9.1875000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      6.5428635982,      5.5428635982,      9.5428635982,
      5.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      5.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      7.5428635982,
      4.5428635982,      10.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      10.5428635982,      4.5428635982,
      5.5428635982,      122.1692218885,      4.5428635982,
      86.2961383049,      26.5428635982,      37.5428635982,
      285.9730258589,      121.5428635982,      121.5428635982,
      1324.4151004319,      982.0729681341,      305.8386410516,
      109.0846109442,      14.5423054721,      763.7268586916,
      679.4484069266,      1325.6778944386,      865.3452136083,
      862.6681058523,      735.8965460493,      1405.0353695812,
      1264.1606137270,      621.5855619753,      692.9131727677,
      554.5228138816,      17.5428635982,      82.5428635982,
      42.5428635982,      109.5428635982,      38.5428635982,
      6.5428635982,      1221.4151004319,      713.0999422752,
      759.3537751080,      531.1692218885,      635.7614984982,
      1001.7421900226,      971.1998845505,      1025.5383283275,
      540.2538328327,      837.6922188850,      696.9307203867,
      509.7115273606,      705.6422477474,      813.0653024686,
      1048.1652447438,      1078.3344666323,      534.3384437770,
      804.3960805801,      777.8114696359,      883.2345243571,
      555.2538328327,      738.7268586916,      711.4730258589,
      943.5729681341,      1192.7575213536,      574.4230547212,
      486.0846109442,      86.5428635982,      744.5428635982,
      86.5428635982,      16.5428635982,      10.5423054721,
      4.5428635982,      900.3191353014,      595.5922766097,
      743.0153313310,      782.8114696359,      1241.7575213536,
      611.3384437770,      611.5499711376,      763.6422477474,
      679.6345820819,      846.6076079407,      687.7191930261,
      956.1152736062,      710.4730258589,      742.9730258589,
      771.7268586916,      720.9730258589,      644.3038039704,
      944.5729681341,      824.4383860522,      1238.2998268257,
      1038.6229392717,      1192.8421322978,      1020.9960228554,
      593.2115273606,      541.3384437770,      554.7961383049,
      34.5428635982,      16.5428635982,      34.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_2, trained with 6 samples
exploit_kit_data_entry caws_2 = {
   .mean = {
      2.0000000000,      1.0000000000,      5.0000000000,
      1.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      1.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      3.0000000000,
      0.0000000000,      6.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      6.0000000000,      0.0000000000,
      1.0000000000,      88.0000000000,      0.0000000000,
      22.0000000000,      22.0000000000,      33.0000000000,
      91.0000000000,      117.0000000000,      117.0000000000,
      39.0000000000,      186.0000000000,      225.1666666667,
      91.3333333333,      5.3333333333,      201.6666666667,
      217.0000000000,      446.5000000000,      251.6666666667,
      222.6666666667,      194.8333333333,      212.8333333333,
      241.8333333333,      200.1666666667,      158.0000000000,
      188.0000000000,      13.0000000000,      184.6666666667,
      38.0000000000,      114.0000000000,      34.0000000000,
      2.0000000000,      0.0000000000,      172.8333333333,
      185.3333333333,      184.5000000000,      162.8333333333,
      162.1666666667,      173.0000000000,      146.5000000000,
      174.8333333333,      169.3333333333,      177.3333333333,
      142.8333333333,      185.1666666667,      162.5000000000,
      182.0000000000,      163.5000000000,      164.6666666667,
      158.5000000000,      165.0000000000,      178.0000000000,
      165.5000000000,      155.6666666667,      163.1666666667,
      163.6666666667,      168.0000000000,      165.5000000000,
      181.0000000000,      82.0000000000,      740.0000000000,
      82.0000000000,      12.0000000000,      4.0000000000,
      0.0000000000,      229.6666666667,      201.3333333333,
      224.6666666667,      202.6666666667,      250.1666666667,
      206.3333333333,      194.1666666667,      211.8333333333,
      204.1666666667,      186.0000000000,      193.6666666667,
      192.5000000000,      190.0000000000,      219.6666666667,
      199.0000000000,      185.3333333333,      166.8333333333,
      194.8333333333,      222.0000000000,      194.3333333333,
      204.8333333333,      187.8333333333,      184.5000000000,
      207.0000000000,      182.1666666667,      173.8333333333,
      30.0000000000,      12.0000000000,      30.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      50.0000000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      128.0000000000,      39.1388888889,
      0.2222222222,      0.2222222222,      14.2222222222,
      62.6666666667,      242.9166666667,      143.2222222222,
      70.5555555556,      48.1388888889,      79.8055555556,
      16.1388888889,      23.1388888889,      12.6666666667,
      191.3333333333,      0.0448140000,      0.8888888889,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      147.8055555556,
      224.2222222222,      18.5833333333,      317.1388888889,
      2.8055555556,      55.6666666667,      0.5833333333,
      64.4722222222,      0.8888888889,      39.2222222222,
      80.4722222222,      140.4722222222,      24.9166666667,
      19.0000000000,      144.9166666667,      11.8888888889,
      0.2500000000,      13.0000000000,      72.3333333333,
      0.5833333333,      59.2222222222,      4.4722222222,
      227.8888888889,      50.0000000000,      24.9166666667,
      200.0000000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      68.5555555556,      47.5555555556,
      0.5555555556,      89.2222222222,      42.4722222222,
      2.5555555556,      59.1388888889,      12.1388888889,
      228.1388888889,      99.0000000000,      22.5555555556,
      4.5833333333,      13.3333333333,      2.2222222222,
      703.3333333333,      197.2222222222,      2.8055555556,
      3.8055555556,      6.6666666667,      7.5555555556,
      93.4722222222,      108.1388888889,      55.5833333333,
      99.3333333333,      107.8055555556,      63.1388888889,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      6.5428635982,      5.5428635982,      9.5428635982,
      5.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      5.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      7.5428635982,
      4.5428635982,      10.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      10.5428635982,      4.5428635982,
      5.5428635982,      92.5428635982,      4.5428635982,
      173.7427129385,      26.5428635982,      37.5428635982,
      95.5428635982,      121.5428635982,      121.5428635982,
      43.5428635982,      428.7883407016,      359.4206216266,
      101.4495141959,      15.4495141959,      282.5961135672,
      386.8795646888,      780.9656321676,      508.4861962490,
      402.9221356268,      343.7251651770,      404.5409662332,
      328.0437329068,      303.3938536127,      234.3754906296,
      484.8370870111,      17.5428635982,      204.8990283918,
      42.5428635982,      118.5428635982,      38.5428635982,
      6.5428635982,      4.5428635982,      433.7298142923,
      506.6713940753,      277.0091415066,      544.9954135988,
      198.1111527523,      333.1107347078,      162.8900862571,
      347.1428094518,      189.5656950585,      311.7301370178,
      335.3400289514,      439.5086588224,      269.6193215380,
      275.5404904487,      421.8342626881,      238.6601506066,
      169.2298301314,      242.3739054319,      360.5122763323,
      181.8900862571,      320.8115764053,      208.5487605396,
      487.6214654935,      319.7427129385,      272.6193215380,
      484.4854258770,      86.5428635982,      744.5428635982,
      86.5428635982,      16.5428635982,      8.5428635982,
      4.5428635982,      407.3489675659,      349.3203012131,
      240.6617530406,      405.3692857187,      390.0208090831,
      240.6389717228,      359.1953453694,      286.6007388000,
      528.2991101794,      399.5209236616,      295.5843648220,
      238.4423878560,      268.3596000159,      251.6568394146,
      768.1194687830,      486.7038524277,      202.7778194189,
      236.6964805939,      277.4086045423,      253.3202973025,
      412.3075464288,      410.9920183664,      344.4908464583,
      420.8800844262,      404.9811478676,      344.3517571730,
      34.5428635982,      16.5428635982,      34.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_3, trained with 4 samples
exploit_kit_data_entry caws_3 = {
   .mean = {
      2.0000000000,      1.2500000000,      5.0000000000,
      1.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      1.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      3.0000000000,
      0.0000000000,      6.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      6.0000000000,      0.0000000000,
      1.0000000000,      88.0000000000,      0.0000000000,
      21.0000000000,      449.2500000000,      33.0000000000,
      55.5000000000,      117.0000000000,      117.0000000000,
      39.0000000000,      659.7500000000,      214.5000000000,
      88.0000000000,      7.2500000000,      630.0000000000,
      978.5000000000,      974.5000000000,      1104.7500000000,
      707.2500000000,      653.7500000000,      637.2500000000,
      659.7500000000,      657.2500000000,      607.5000000000,
      637.0000000000,      144.2500000000,      78.0000000000,
      38.0000000000,      105.2500000000,      34.0000000000,
      2.0000000000,      0.0000000000,      618.2500000000,
      573.2500000000,      622.7500000000,      677.2500000000,
      621.0000000000,      590.5000000000,      611.2500000000,
      613.2500000000,      624.0000000000,      591.0000000000,
      600.7500000000,      573.0000000000,      618.7500000000,
      610.5000000000,      617.0000000000,      629.0000000000,
      584.7500000000,      593.5000000000,      631.0000000000,
      585.2500000000,      601.5000000000,      618.7500000000,
      590.5000000000,      603.7500000000,      646.7500000000,
      584.7500000000,      82.0000000000,      740.0000000000,
      82.0000000000,      12.0000000000,      6.0000000000,
      0.0000000000,      693.0000000000,      608.0000000000,
      638.2500000000,      658.0000000000,      692.5000000000,
      651.5000000000,      621.2500000000,      618.5000000000,
      663.2500000000,      617.0000000000,      611.7500000000,
      627.7500000000,      627.7500000000,      693.0000000000,
      638.2500000000,      599.7500000000,      615.2500000000,
      678.2500000000,      642.0000000000,      651.0000000000,
      653.2500000000,      626.5000000000,      593.2500000000,
      648.2500000000,      627.5000000000,      635.2500000000,
      30.0000000000,      12.0000000000,      30.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.1875000000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      3.0000000000,      547627.6875000000,      0.0448140000,
      0.7500000000,      0.0448140000,      0.0448140000,
      0.0448140000,      697.6875000000,      36.2500000000,
      0.0448140000,      15.1875000000,      12.0000000000,
      427519.2500000000,      280.7500000000,      437713.1875000000,
      540.6875000000,      160.6875000000,      531.1875000000,
      539.1875000000,      713.1875000000,      380.2500000000,
      328.5000000000,      0.1875000000,      0.0448140000,
      0.0448140000,      0.1875000000,      0.0448140000,
      0.0448140000,      0.0448140000,      2887.6875000000,
      10.6875000000,      1215.1875000000,      7070.6875000000,
      246.0000000000,      142.2500000000,      180.1875000000,
      88.6875000000,      144.0000000000,      3.0000000000,
      117.1875000000,      243.0000000000,      463.6875000000,
      84.7500000000,      108.0000000000,      803.0000000000,
      450.1875000000,      238.2500000000,      475.0000000000,
      55.6875000000,      254.7500000000,      475.1875000000,
      6.2500000000,      450.1875000000,      256.6875000000,
      697.6875000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.5000000000,
      0.0448140000,      3480.5000000000,      904.5000000000,
      445.6875000000,      1985.5000000000,      2040.2500000000,
      42.7500000000,      150.1875000000,      4.2500000000,
      1193.1875000000,      75.0000000000,      132.6875000000,
      468.1875000000,      633.1875000000,      1204.5000000000,
      820.1875000000,      385.6875000000,      229.6875000000,
      2428.1875000000,      306.0000000000,      988.5000000000,
      501.1875000000,      174.2500000000,      123.1875000000,
      217.6875000000,      616.7500000000,      627.6875000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      6.5428635982,      10.5423054721,      9.5428635982,
      5.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      5.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      7.5428635982,
      4.5428635982,      10.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      10.5428635982,      4.5428635982,
      5.5428635982,      92.5428635982,      4.5428635982,
      58.1692218885,      16329.8000518609,      37.5428635982,
      74.0846109442,      121.5428635982,      121.5428635982,
      43.5428635982,      1226.5806337996,      343.7042643422,
      92.5428635982,      90.8807492491,      704.3384437770,
      15009.8894680320,      1334.0693993816,      15302.4389707051,
      1206.2447850365,      925.7781757945,      1131.8416333875,
      1158.0521372278,      1230.3424717722,      1025.9633751264,
      1025.9470923014,      153.5423054721,      82.5428635982,
      42.5428635982,      114.5423054721,      38.5428635982,
      6.5428635982,      4.5428635982,      1771.4322224371,
      643.4053678365,      1370.8238763909,      2481.7366103532,
      957.5816194852,      846.4463730856,      899.3114696359,
      815.3442925641,      881.5159231547,      628.1692218885,
      833.0576368031,      907.5229969965,      1080.8495402092,
      808.0571242103,      840.0153313310,      1237.1078571560,
      1040.0729681341,      924.7373464469,      1098.7024522433,
      745.3906927462,      944.0152704451,      1086.5447528302,
      644.1491506572,      1059.0729681341,      990.5653024686,
      1151.5806337996,      86.5428635982,      744.5428635982,
      86.5428635982,      16.5428635982,      21.1742712939,
      4.5428635982,      1959.0290214814,      1253.3972755773,
      1091.2915860898,      1614.2199226266,      1661.8141117286,
      791.8107356730,      884.2403034920,      662.7402229769,
      1404.5213066950,      802.8461094425,      858.9439560453,
      1092.0864207611,      1167.7440922955,      1437.7769793047,
      1252.8314040402,      1021.1947266378,      940.4806915244,
      1735.7100078012,      1017.3907400180,      1325.7007283862,
      1133.6720782385,      909.7756440128,      831.4304782694,
      964.8709065842,      1160.4389000822,      1172.8937260043,
      34.5428635982,      16.5428635982,      34.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_4, trained with 5 samples
exploit_kit_data_entry caws_4 = {
   .mean = {
      1.0000000000,      2.0000000000,      2.0000000000,
      1.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      1.0000000000,      2.0000000000,
      0.0000000000,      0.0000000000,      3.0000000000,
      0.0000000000,      6.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      6.0000000000,      0.0000000000,
      1.0000000000,      86.0000000000,      0.0000000000,
      4.0000000000,      22.0000000000,      151.0000000000,
      67.0000000000,      117.0000000000,      117.0000000000,
      29.0000000000,      134.0000000000,      179.0000000000,
      92.0000000000,      5.0000000000,      128.0000000000,
      151.0000000000,      373.0000000000,      196.6000000000,
      176.0000000000,      143.0000000000,      142.0000000000,
      156.0000000000,      126.0000000000,      130.0000000000,
      119.0000000000,      13.0000000000,      75.0000000000,
      37.0000000000,      101.0000000000,      34.0000000000,
      2.0000000000,      0.0000000000,      129.0000000000,
      159.0000000000,      138.0000000000,      124.0000000000,
      120.0000000000,      119.6000000000,      108.0000000000,
      145.6000000000,      143.0000000000,      132.6000000000,
      122.0000000000,      125.0000000000,      113.0000000000,
      118.0000000000,      111.0000000000,      140.0000000000,
      128.0000000000,      114.0000000000,      141.0000000000,
      119.0000000000,      118.0000000000,      141.0000000000,
      129.0000000000,      114.0000000000,      118.0000000000,
      135.6000000000,      81.0000000000,      736.0000000000,
      81.0000000000,      12.0000000000,      2.0000000000,
      0.0000000000,      174.0000000000,      151.0000000000,
      174.0000000000,      163.0000000000,      196.0000000000,
      158.0000000000,      152.0000000000,      143.0000000000,
      146.0000000000,      128.0000000000,      143.6000000000,
      142.4000000000,      115.2000000000,      158.0000000000,
      166.0000000000,      121.0000000000,      107.0000000000,
      159.0000000000,      162.0000000000,      169.0000000000,
      144.0000000000,      133.0000000000,      143.2000000000,
      157.0000000000,      149.6000000000,      119.0000000000,
      31.0000000000,      12.0000000000,      31.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.2400000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      17.2000000000,      0.0448140000,      0.0448140000,
      0.0448140000,      1.8400000000,      0.0448140000,
      2.6400000000,      0.0448140000,      1.4400000000,
      6.8000000000,      0.4000000000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.2400000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      2.8000000000,      0.0448140000,
      0.0448140000,      0.0448140000,      14.2400000000,
      0.2400000000,      2.9600000000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.9600000000,
      1.2000000000,      1.8400000000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      5.5428635982,      6.5428635982,      6.5428635982,
      5.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      5.5428635982,      6.5428635982,
      4.5428635982,      4.5428635982,      7.5428635982,
      4.5428635982,      10.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      10.5428635982,      4.5428635982,
      5.5428635982,      90.5428635982,      4.5428635982,
      8.5428635982,      26.5428635982,      155.5428635982,
      71.5428635982,      121.5428635982,      121.5428635982,
      33.5428635982,      138.5428635982,      183.5428635982,
      96.5428635982,      9.5428635982,      132.5428635982,
      155.5428635982,      377.5428635982,      207.1130435395,
      180.5428635982,      147.5428635982,      146.5428635982,
      160.5428635982,      130.5428635982,      134.5428635982,
      123.5428635982,      17.5428635982,      79.5428635982,
      41.5428635982,      105.5428635982,      38.5428635982,
      6.5428635982,      4.5428635982,      133.5428635982,
      247.9993973008,      142.5428635982,      128.5428635982,
      124.5428635982,      148.7092994457,      112.5428635982,
      180.4678208252,      147.5428635982,      158.3515923155,
      177.9599475203,      138.5722808488,      117.5428635982,
      122.5428635982,      115.5428635982,      144.5428635982,
      132.5428635982,      118.5428635982,      145.5428635982,
      123.5428635982,      122.5428635982,      145.5428635982,
      133.5428635982,      118.5428635982,      122.5428635982,
      146.1130435395,      85.5428635982,      740.5428635982,
      85.5428635982,      16.5428635982,      6.5428635982,
      4.5428635982,      178.5428635982,      155.5428635982,
      178.5428635982,      167.5428635982,      200.5428635982,
      162.5428635982,      187.9088798499,      147.5428635982,
      150.5428635982,      132.5428635982,      224.5800120082,
      152.9130435395,      152.1205955403,      162.5428635982,
      170.5428635982,      125.5428635982,      111.5428635982,
      163.5428635982,      166.5428635982,      173.5428635982,
      148.5428635982,      137.5428635982,      164.2260870790,
      180.5078800048,      178.7092994457,      123.5428635982,
      35.5428635982,      16.5428635982,      35.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_5, trained with 3 samples
exploit_kit_data_entry caws_5 = {
   .mean = {
      109.0000000000,      28.0000000000,      151.0000000000,
      7.0000000000,      0.0000000000,      872.0000000000,
      3.0000000000,      21.0000000000,      28.0000000000,
      0.0000000000,      23.0000000000,      3.0000000000,
      10.0000000000,      122.0000000000,      3.0000000000,
      3.0000000000,      0.0000000000,      2.0000000000,
      0.0000000000,      159.0000000000,      0.0000000000,
      126.0000000000,      452.0000000000,      0.0000000000,
      25.0000000000,      19.0000000000,      273.3333333333,
      6.0000000000,      1171.0000000000,      1171.0000000000,
      64.0000000000,      446.0000000000,      1268.0000000000,
      210.0000000000,      1973.6666666667,      33.6666666667,
      604.6666666667,      1088.6666666667,      290.6666666667,
      230.3333333333,      307.6666666667,      273.6666666667,
      357.3333333333,      286.0000000000,      279.3333333333,
      266.0000000000,      216.0000000000,      724.0000000000,
      231.0000000000,      1284.6666666667,      192.0000000000,
      63.3333333333,      0.0000000000,      467.0000000000,
      294.3333333333,      247.0000000000,      300.3333333333,
      401.6666666667,      425.3333333333,      53.0000000000,
      42.6666666667,      1702.3333333333,      39.0000000000,
      36.6666666667,      45.0000000000,      80.6666666667,
      47.3333333333,      41.6666666667,      32.6666666667,
      21.6666666667,      30.6666666667,      92.6666666667,
      43.0000000000,      30.3333333333,      36.3333333333,
      39.0000000000,      35.6666666667,      28.6666666667,
      31.0000000000,      337.0000000000,      1.0000000000,
      337.0000000000,      7.0000000000,      29.0000000000,
      0.0000000000,      1608.3333333333,      691.0000000000,
      1130.6666666667,      547.0000000000,      1097.6666666667,
      692.6666666667,      280.0000000000,      1218.3333333333,
      1335.3333333333,      56.0000000000,      118.3333333333,
      1389.0000000000,      92.6666666667,      700.0000000000,
      874.0000000000,      488.0000000000,      35.6666666667,
      893.6666666667,      1280.3333333333,      1819.0000000000,
      419.6666666667,      187.3333333333,      145.6666666667,
      80.6666666667,      156.3333333333,      41.3333333333,
      485.0000000000,      46.0000000000,      485.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.2222222222,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.2222222222,      0.8888888889,
      6.2222222222,      9.5555555556,      0.2222222222,
      6.8888888889,      0.2222222222,      0.8888888889,
      1.5555555556,      2.0000000000,      6.8888888889,
      4.6666666667,      0.0448140000,      0.0448140000,
      0.0448140000,      0.8888888889,      0.0448140000,
      0.2222222222,      0.0448140000,      2.0000000000,
      0.2222222222,      2.0000000000,      0.2222222222,
      0.8888888889,      0.2222222222,      0.0448140000,
      0.8888888889,      0.2222222222,      0.0448140000,
      0.2222222222,      0.6666666667,      0.8888888889,
      0.2222222222,      0.8888888889,      2.8888888889,
      0.2222222222,      0.8888888889,      0.2222222222,
      0.0448140000,      0.2222222222,      0.8888888889,
      0.0448140000,      5.5555555556,      0.2222222222,
      0.6666666667,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      16.2222222222,      0.6666666667,
      2.8888888889,      8.6666666667,      2.8888888889,
      5.5555555556,      2.0000000000,      1.5555555556,
      1.5555555556,      0.0448140000,      0.2222222222,
      2.0000000000,      0.8888888889,      0.6666666667,
      0.0448140000,      2.0000000000,      0.8888888889,
      0.2222222222,      0.2222222222,      0.6666666667,
      0.2222222222,      3.5555555556,      0.2222222222,
      0.2222222222,      0.2222222222,      0.2222222222,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      113.5428635982,      32.5428635982,      155.5428635982,
      11.5428635982,      4.5428635982,      876.5428635982,
      7.5428635982,      25.5428635982,      32.5428635982,
      4.5428635982,      27.5428635982,      7.5428635982,
      14.5428635982,      126.5428635982,      7.5428635982,
      7.5428635982,      4.5428635982,      6.5428635982,
      4.5428635982,      163.5428635982,      4.5428635982,
      130.5428635982,      456.5428635982,      4.5428635982,
      29.5428635982,      23.5428635982,      283.4495141959,
      10.5428635982,      1175.5428635982,      1175.5428635982,
      68.5428635982,      450.5428635982,      1272.5428635982,
      214.5428635982,      1983.7828475292,      53.8990283918,
      658.1964642269,      1155.0029007737,      300.7828475292,
      286.6578446279,      317.7828475292,      293.8990283918,
      384.0982321134,      316.3485425877,      335.6578446279,
      312.3581645466,      220.5428635982,      728.5428635982,
      235.5428635982,      1304.8990283918,      196.5428635982,
      73.4495141959,      4.5428635982,      497.3485425877,
      304.4495141959,      277.3485425877,      310.4495141959,
      421.8990283918,      435.4495141959,      57.5428635982,
      62.8990283918,      1712.4495141959,      43.5428635982,
      46.7828475292,      62.5217392325,      100.8990283918,
      57.4495141959,      61.8990283918,      69.1410754785,
      31.7828475292,      50.8990283918,      102.7828475292,
      47.5428635982,      40.4495141959,      56.5656950585,
      43.5428635982,      86.2475709795,      38.7828475292,
      48.5217392325,      341.5428635982,      5.5428635982,
      341.5428635982,      11.5428635982,      33.5428635982,
      4.5428635982,      1694.7660205114,      708.5217392325,
      1167.1410754785,      610.1755292382,      1134.1410754785,
      743.2475709795,      310.3485425877,      1245.0982321134,
      1362.0982321134,      60.5428635982,      128.4495141959,
      1419.3485425877,      112.8990283918,      717.5217392325,
      878.5428635982,      518.3485425877,      55.8990283918,
      903.7828475292,      1290.4495141959,      1836.5217392325,
      429.7828475292,      227.7980567836,      155.7828475292,
      90.7828475292,      166.4495141959,      51.4495141959,
      489.5428635982,      50.5428635982,      489.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_6, trained with 7 samples
exploit_kit_data_entry caws_6 = {
   .mean = {
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,        19.0000000000,         0.0000000000,
         0.0000000000,      2545.1428571429,         0.0000000000,
         0.0000000000,      1207.8571428571,      3185.4285714286,
         0.1428571429,      2044.1428571429,      2044.1428571429,
         3.0000000000,        17.0000000000,        72.5714285714,
         3.0000000000,        10.2857142857,         1.1428571429,
       503.8571428571,       668.1428571429,      1055.8571428571,
       963.2857142857,       866.7142857143,       785.7142857143,
       817.8571428571,       540.7142857143,       612.2857142857,
       635.1428571429,         0.2857142857,         0.0000000000,
         1.0000000000,       209.7142857143,         1.0000000000,
         0.0000000000,         0.0000000000,       296.8571428571,
       586.0000000000,        46.4285714286,        53.7142857143,
       338.0000000000,        50.7142857143,        43.5714285714,
        36.2857142857,        67.0000000000,        47.5714285714,
        55.2857142857,       316.7142857143,        44.5714285714,
        61.4285714286,        45.8571428571,       337.2857142857,
        37.4285714286,        48.1428571429,        49.5714285714,
        60.0000000000,        49.5714285714,        45.5714285714,
        45.2857142857,        49.4285714286,        47.7142857143,
        47.0000000000,        21.8571428571,        25.1428571429,
        23.4285714286,        21.8571428571,        20.5714285714,
        25.0000000000,        93.2857142857,       143.5714285714,
       489.8571428571,       131.4285714286,       485.8571428571,
       116.5714285714,        50.1428571429,       157.1428571429,
       348.5714285714,        59.5714285714,        51.1428571429,
        63.7142857143,        70.4285714286,       121.8571428571,
       155.0000000000,        54.5714285714,        39.1428571429,
       180.2857142857,        71.2857142857,       107.1428571429,
        76.8571428571,        42.8571428571,        46.8571428571,
        55.7142857143,        46.8571428571,        45.8571428571,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,
   },
   .var = {
         0.0204081633,         0.0204081633,         0.0204081633,
         0.0204081633,         0.0204081633,         0.0204081633,
         0.0204081633,         0.0204081633,         0.0204081633,
         0.0204081633,         0.0204081633,         0.0204081633,
         0.0204081633,         0.0204081633,         0.0204081633,
         0.0204081633,         0.0204081633,         0.0204081633,
         0.0204081633,         0.4081632653,         0.0204081633,
         0.0204081633,      26055.8367346939,         0.0204081633,
         0.0204081633,      1301.5510204082,      28115.1020408163,
         0.1224489796,      9966.4081632653,      9966.4081632653,
         0.0816326531,         0.3673469388,         2.8163265306,
         0.0816326531,         0.2040816327,         0.1224489796,
       985.2653061224,      2658.9795918367,      5770.6938775510,
      4181.3469387755,      2207.9183673469,      1579.3469387755,
      2697.8367346939,      1147.3469387755,      420514.7755102041,
      467203.8367346940,         0.2040816327,         0.0204081633,
         0.0408163265,        49.6326530612,         0.0408163265,
         0.0204081633,         0.0204081633,      370639.5510204081,
      745713.4285714288,       127.6734693878,       163.6326530612,
      425714.5714285714,        41.6326530612,       155.9591836735,
        83.6326530612,        61.7142857143,       124.8163265306,
       164.2040816327,      431726.4897959183,       122.2448979592,
       226.2448979592,        40.6938775510,      510904.4897959185,
        22.2448979592,        38.4081632653,       169.9591836735,
        57.7142857143,        60.5306122449,        63.6734693878,
        62.2040816327,        79.3877551020,       213.9183673469,
       140.2857142857,        16.9795918367,        22.1224489796,
        36.2448979592,        10.6938775510,        38.5306122449,
        16.5714285714,        25.6326530612,       113.6734693878,
      453478.1224489796,        91.6734693878,      411502.6938775509,
        96.5306122449,        88.4081632653,        46.4081632653,
      411201.9591836735,       112.2448979592,       134.6938775510,
       241.6326530612,       116.8163265306,        74.4081632653,
       151.4285714286,       103.9591836735,       114.9795918367,
        15.9183673469,       229.6326530612,        87.8367346939,
        37.2653061224,       101.2653061224,       133.2653061224,
        27.6326530612,       178.1224489796,       273.2653061224,
         0.0204081633,         0.0204081633,         0.0204081633,
         0.0204081633,         0.0204081633,
   },
   .precheck = {
         3.0656657518,         3.0656657518,         3.0656657518,
         3.0656657518,         3.0656657518,         3.0656657518,
         3.0656657518,         3.0656657518,         3.0656657518,
         3.0656657518,         3.0656657518,         3.0656657518,
         3.0656657518,         3.0656657518,         3.0656657518,
         3.0656657518,         3.0656657518,         3.0656657518,
         3.0656657518,        32.7100740348,         3.0656657518,
         3.0656657518,      6009.1226853403,         3.0656657518,
         3.0656657518,      1982.0576307623,      6783.6896749949,
         7.6521739568,      4186.5015044019,      4186.5015044019,
         9.1313315037,        30.0065182519,       108.5848468663,
         9.1313315037,        19.9802006063,         8.6521739568,
      1177.4530464257,      1774.7165574212,      2686.0420218620,
      2350.9389223936,      1875.0713573115,      1638.5426058222,
      1932.4870050659,      1267.6068441735,      14528.2553425476,
      15303.3164984312,         9.9802006063,         3.0656657518,
         5.3355060840,       360.8985488269,         5.3355060840,
         3.0656657518,         3.0656657518,      13361.5355166526,
      19117.4253325213,       288.9070353725,       328.2240697533,
      14339.7429346619,       189.1792461343,       311.5674328111,
       232.5362175851,       235.5837443590,       287.3213869996,
       330.2743942622,      14416.9765503300,       281.8389062144,
       384.2127499153,       182.7520776247,      15676.1322298997,
       138.6419800620,       181.1376421413,       329.3375747521,
       223.0288648912,       216.5306364187,       216.8101983822,
       214.5371196511,       240.6337290286,       361.5821699493,
       301.1730884552,       110.2844633507,       126.0773123511,
       152.6237429621,        92.0334394754,       153.7780450580,
       112.3580269903,       201.9331853402,       372.3695212563,
      14940.9606630036,       336.8967996466,      14251.9020988301,
       327.4125767246,       251.9186331090,       303.3336536575,
      14109.5852097307,       286.9272856789,       300.1987201803,
       397.2947842208,       302.3680170120,       306.9685296121,
       419.0746755086,       273.3749324768,       269.2516549589,
       265.9050991911,       396.4775726719,       308.2654843748,
       207.8583171751,       258.8071298055,       294.5887344198,
       168.5207882030,       333.2631818116,       400.6011689689,
         3.0656657518,         3.0656657518,         3.0656657518,
         3.0656657518,         3.0656657518,
   }
};

// Family: caws_7, trained with 5 samples
exploit_kit_data_entry caws_7 = {
   .mean = {
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,      1372.8000000000,         0.0000000000,
         0.0000000000,         0.0000000000,      1798.0000000000,
         0.0000000000,      1204.0000000000,      1204.0000000000,
         0.0000000000,        10.6000000000,        76.4000000000,
         5.0000000000,         9.6000000000,         1.2000000000,
       227.6000000000,       474.8000000000,       441.6000000000,
       642.4000000000,       425.6000000000,       238.8000000000,
       192.4000000000,       218.0000000000,       204.0000000000,
       193.2000000000,         0.2000000000,         0.0000000000,
         0.0000000000,       130.4000000000,         1.0000000000,
         0.0000000000,         0.0000000000,        21.8000000000,
       248.0000000000,        39.6000000000,        49.8000000000,
        64.0000000000,       265.0000000000,       280.8000000000,
        36.4000000000,        40.0000000000,        28.8000000000,
        24.8000000000,       246.6000000000,       261.2000000000,
        49.8000000000,        27.8000000000,        31.8000000000,
        28.4000000000,        39.0000000000,        45.6000000000,
       244.0000000000,        24.8000000000,        25.8000000000,
        33.0000000000,        31.6000000000,        35.4000000000,
        26.0000000000,        10.8000000000,        11.0000000000,
        12.2000000000,        13.2000000000,        13.4000000000,
        10.2000000000,        55.8000000000,        35.0000000000,
       100.6000000000,        55.6000000000,        95.2000000000,
        46.4000000000,        38.6000000000,        94.0000000000,
        67.2000000000,        32.0000000000,        28.4000000000,
        55.6000000000,        53.0000000000,        76.0000000000,
        71.4000000000,        32.0000000000,        39.6000000000,
        96.4000000000,        58.8000000000,        62.6000000000,
        61.0000000000,        36.2000000000,        34.0000000000,
        39.6000000000,       252.8000000000,        37.4000000000,
         0.0000000000,         0.0000000000,         0.0000000000,
         0.0000000000,         0.0000000000,
   },
   .var = {
         0.0400000000,         0.0400000000,         0.0400000000,
         0.0400000000,         0.0400000000,         0.0400000000,
         0.0400000000,         0.0400000000,         0.0400000000,
         0.0400000000,         0.0400000000,         0.0400000000,
         0.0400000000,         0.0400000000,         0.0400000000,
         0.0400000000,         0.0400000000,         0.0400000000,
         0.0400000000,         0.0400000000,         0.0400000000,
         0.0400000000,      16796.1600000000,         0.0400000000,
         0.0400000000,         0.0400000000,      12258.8000000000,
         0.0400000000,      3091.6000000000,      3091.6000000000,
         0.0400000000,         5.8400000000,         2.6400000000,
         7.2000000000,         0.2400000000,         0.1600000000,
       372.6400000000,       174.1600000000,      5642.2400000000,
      193579.8400000000,      1026.6400000000,      1869.7600000000,
       489.4400000000,      1664.0000000000,       894.0000000000,
       109.7600000000,         0.1600000000,         0.0400000000,
         0.0400000000,        49.0400000000,         0.0800000000,
         0.0400000000,         0.0400000000,        46.5600000000,
      181982.8000000000,        39.0400000000,        31.3600000000,
        14.0000000000,      192291.2000000000,      236306.5600000001,
       106.2400000000,        58.0000000000,       112.1600000000,
        56.1600000000,      183440.2400000000,      199338.5600000001,
        75.7600000000,        55.7600000000,        17.3600000000,
        17.0400000000,        65.2000000000,        24.2400000000,
      173521.6000000001,         9.3600000000,        49.3600000000,
       233.2000000000,        65.0400000000,        41.0400000000,
       112.8000000000,        10.9600000000,         5.2000000000,
         1.7600000000,         9.7600000000,         1.0400000000,
        18.9600000000,        89.3600000000,        15.2000000000,
        48.6400000000,        31.4400000000,        22.9600000000,
       213.0400000000,       133.8400000000,        39.6000000000,
         6.9600000000,        23.6000000000,        23.4400000000,
       197.0400000000,        61.2000000000,        17.6000000000,
        21.8400000000,        80.8000000000,        88.2400000000,
        60.2400000000,       301.3600000000,        36.2400000000,
        51.2000000000,        61.3600000000,       106.0000000000,
        48.6400000000,      182997.7600000000,       113.0400000000,
         0.0400000000,         0.0400000000,         0.0400000000,
         0.0400000000,         0.0400000000,
   },
   .precheck = {
         4.2919320526,         4.2919320526,         4.2919320526,
         4.2919320526,         4.2919320526,         4.2919320526,
         4.2919320526,         4.2919320526,         4.2919320526,
         4.2919320526,         4.2919320526,         4.2919320526,
         4.2919320526,         4.2919320526,         4.2919320526,
         4.2919320526,         4.2919320526,         4.2919320526,
         4.2919320526,         4.2919320526,         4.2919320526,
         4.2919320526,      4153.9719700710,         4.2919320526,
         4.2919320526,         4.2919320526,      4174.0021101841,
         4.2919320526,      2397.2034255315,      2397.2034255315,
         4.2919320526,        62.4596123069,       111.2678208252,
        62.5823109463,        20.1130435395,         9.7838641052,
       641.8548271423,       758.0024787306,      2053.5390630601,
      10084.1588815662,      1113.1937695866,      1166.7311939445,
       667.1583064918,      1093.3858114845,       845.6402532785,
       418.0251497529,         8.7838641052,         4.2919320526,
         4.2919320526,       280.6789226475,         7.0697085175,
         4.2919320526,         4.2919320526,       168.2297523933,
      9402.5713439933,       173.6842436907,       169.9740974722,
       144.2946963403,      9675.2800238243,      10712.6355281581,
       257.5907051753,       203.4319034911,       256.0698589916,
       185.6186424657,      9437.7562066940,      9842.3689966820,
       236.5853563025,       188.0449030611,       121.2123897616,
       116.9844794359,       212.2792821218,       151.2547799715,
      9183.2197587091,        90.4539358613,       176.5684318352,
       360.7080541232,       204.6665389082,       172.8758831334,
       253.9173527793,        81.8441167434,        59.9355545255,
        40.6694564882,        80.2421218453,        35.2846452871,
       103.6419748969,       258.6590663046,       118.6651581168,
       250.2647847179,       175.9272831271,       198.0273832548,
       359.6228370383,       286.8651763121,       229.0424893747,
       123.8144720849,       136.2506673309,       132.2966742295,
       356.8312622301,       220.8798425608,       166.0283262498,
       171.6880435855,       224.8983543289,       241.1837833784,
       262.9579334658,       431.3337685700,       191.7864418351,
       214.5528291900,       204.2991500907,       254.9407250180,
       189.2647847179,      9432.8644249079,       265.5596892144,
         4.2919320526,         4.2919320526,         4.2919320526,
         4.2919320526,         4.2919320526,
   }
};

// Family: caws_8, trained with 30 samples
exploit_kit_data_entry caws_8 = {
   .mean = {
      2.6000000000,      0.1000000000,      1.7000000000,
      0.0000000000,      0.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.9333333333,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.0000000000,      25.3333333333,      0.0000000000,
      0.0000000000,      0.0000000000,      3.6666666667,
      13.0000000000,      15.0000000000,      15.0000000000,
      27.9333333333,      27.6333333333,      21.3333333333,
      8.6333333333,      4.0000000000,      34.0000000000,
      262.2000000000,      195.9000000000,      201.2666666667,
      154.9000000000,      218.8333333333,      118.6000000000,
      14.8666666667,      23.1666666667,      17.7333333333,
      126.2333333333,      2.0000000000,      39.0000000000,
      3.0000000000,      18.0000000000,      2.0000000000,
      1.0000000000,      0.0000000000,      1064.2666666667,
      194.9000000000,      1345.0333333333,      866.1333333333,
      280.4333333333,      189.9666666667,      254.5666666667,
      101.6333333333,      710.3333333333,      252.1000000000,
      207.1666666667,      864.2666666667,      1032.0000000000,
      389.2666666667,      132.2666666667,      84.3666666667,
      274.1666666667,      255.4333333333,      240.2000000000,
      259.8333333333,      254.4333333333,      184.0000000000,
      186.8333333333,      152.3333333333,      235.7000000000,
      447.3333333333,      14.0000000000,      5.0000000000,
      14.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      252.5333333333,      207.4666666667,
      228.7333333333,      225.2333333333,      85.4000000000,
      66.1666666667,      768.3333333333,      180.8000000000,
      269.5000000000,      279.3666666667,      247.5000000000,
      229.0666666667,      472.8000000000,      85.3333333333,
      293.8000000000,      155.5333333333,      26.0666666667,
      73.3666666667,      811.6333333333,      134.0333333333,
      198.8666666667,      69.3000000000,      1379.4333333333,
      235.4333333333,      216.8000000000,      229.6333333333,
      12.6666666667,      2.6666666667,      12.6666666667,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.3733333333,      0.0900000000,      1.4766666667,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.1288888889,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      4.8222222222,      0.0448140000,
      0.0448140000,      0.0448140000,      0.2222222222,
      0.0448140000,      0.0448140000,      0.0448140000,
      53.9955555556,      0.7655555556,      3.5555555556,
      0.2322222222,      0.2000000000,      28.8000000000,
      14894.2933333333,      13422.3566666667,      4946.1955555556,
      4101.4233333333,      49256.4722222222,      1167.3066666667,
      9.2488888889,      554.0722222222,      282.7288888889,
      2170.8455555556,      0.0448140000,      18.0000000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      419549.5288888888,
      3465.6233333333,      488717.8988888889,      107640.6488888889,
      52014.1788888889,      11097.9655555556,      7893.3788888889,
      441.8322222222,      50140.7555555556,      3166.7566666667,
      6737.4055555556,      91471.9288888889,      11456.5333333333,
      30271.1955555556,      12573.5288888889,      1614.8988888889,
      34220.0722222222,      29209.1122222222,      4467.0266666667,
      50784.9388888889,      34413.7122222222,      2191.6666666667,
      1942.3388888889,      2865.2222222222,      2740.9433333333,
      360.4888888889,      7.8000000000,      0.0448140000,
      7.8000000000,      0.0448140000,      0.0448140000,
      0.0448140000,      5381.4488888889,      3737.3822222222,
      2121.3288888889,      7424.7122222222,      103.5066666667,
      105.9388888889,      124800.7555555556,      1696.4266666667,
      4847.5166666667,      49987.9655555556,      12457.9833333333,
      1709.7955555556,      23895.0933333333,      946.0888888889,
      4619.3600000000,      2743.5155555556,      147.1955555556,
      114.9655555556,      187879.4988888889,      3086.8322222222,
      27173.1155555555,      101.5433333333,      653879.7788888889,
      29615.2455555556,      3288.6933333333,      10173.2322222222,
      0.2222222222,      0.2222222222,      0.2222222222,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      15.7120690057,      6.5378980789,      27.7773873461,
      4.5428635982,      4.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      9.6375871481,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      5.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      5.5428635982,      72.4578004475,      4.5428635982,
      4.5428635982,      4.5428635982,      13.7828475292,
      17.5428635982,      19.5428635982,      19.5428635982,
      185.6224967595,      46.4096844702,      61.7980567836,
      18.9746236508,      13.5970518244,      149.1646218925,
      2881.1836883804,      2682.1066838264,      1710.5072805686,
      1529.2271973872,      4981.5472376607,      851.7879608421,
      80.1297552885,      528.3000033870,      378.5677343858,
      1126.0889844565,      6.5428635982,      130.0456277631,
      7.5428635982,      22.5428635982,      6.5428635982,
      5.5428635982,      4.5428635982,      14964.2558104914,
      1458.2204364108,      16347.1301778476,      7906.7548049331,
      5174.6559055889,      2450.6749650008,      2161.1435239116,
      552.7112176268,      5515.6086905565,      1459.7196995583,
      1968.6120730121,      7354.5963946076,      3328.9389574267,
      4122.9512712719,      2538.5758814554,      946.7403801167,
      4243.9179984271,      3923.0338127334,      1674.4739635560,
      5095.8780650158,      4235.4005715174,      1188.6391387437,
      1132.6029216685,      1301.0211044012,      1359.1994668512,
      854.7781373855,      73.9335694338,      9.5428635982,
      73.9335694338,      4.5428635982,      4.5428635982,
      4.5428635982,      1826.7788027735,      1519.3843921136,
      1217.1199254007,      2074.3429397472,      303.7267769616,
      287.0436941385,      8349.4197902551,      1064.6740582260,
      1763.6097426031,      5077.3150681675,      2642.7272005846,
      1116.4166267489,      3790.0424000979,      745.4015377187,
      1752.3245609981,      1279.5598473106,      286.4242254113,
      303.4614186407,      10113.3378375707,      1326.3163416382,
      3736.3349932649,      285.5462326267,      18732.3226113746,
      3928.4435673181,      1447.4499294895,      2394.1070736432,
      22.7828475292,      12.7828475292,      22.7828475292,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_9, trained with 3 samples
exploit_kit_data_entry caws_9 = {
   .mean = {
      0.6666666667,      0.0000000000,      0.6666666667,
      0.0000000000,      0.6666666667,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      2.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      3.3333333333,      0.0000000000,
      1.0000000000,      59.3333333333,      0.0000000000,
      0.0000000000,      435.0000000000,      399.3333333333,
      377.6666666667,      291.0000000000,      290.6666666667,
      2.0000000000,      11.0000000000,      2091.0000000000,
      7.6666666667,      234.6666666667,      9.3333333333,
      1786.6666666667,      124.6666666667,      235.6666666667,
      192.3333333333,      147.0000000000,      173.3333333333,
      221.3333333333,      153.6666666667,      77.0000000000,
      61.0000000000,      6.3333333333,      194.0000000000,
      8.0000000000,      93.6666666667,      7.6666666667,
      0.3333333333,      0.0000000000,      21.6666666667,
      41.0000000000,      60.3333333333,      64.0000000000,
      55.0000000000,      35.6666666667,      6.0000000000,
      4.3333333333,      17.6666666667,      0.6666666667,
      2.3333333333,      13.3333333333,      14.6666666667,
      20.6666666667,      13.3333333333,      12.0000000000,
      0.3333333333,      14.3333333333,      49.0000000000,
      26.0000000000,      6.6666666667,      2.0000000000,
      11.0000000000,      2.3333333333,      0.3333333333,
      1.6666666667,      0.0000000000,      250.6666666667,
      0.0000000000,      0.0000000000,      1.6666666667,
      0.0000000000,      150.0000000000,      43.0000000000,
      328.0000000000,      306.0000000000,      625.3333333333,
      80.3333333333,      35.0000000000,      396.3333333333,
      331.0000000000,      11.6666666667,      31.6666666667,
      79.6666666667,      260.3333333333,      497.6666666667,
      306.3333333333,      42.6666666667,      7.0000000000,
      350.3333333333,      110.6666666667,      558.6666666667,
      256.0000000000,      14.6666666667,      221.0000000000,
      47.6666666667,      33.0000000000,      6.3333333333,
      3.3333333333,      0.6666666667,      3.3333333333,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.2222222222,      0.0448140000,      0.2222222222,
      0.0448140000,      0.2222222222,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      2.0000000000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.8888888889,      0.0448140000,
      0.0448140000,      555.5555555556,      0.0448140000,
      0.0448140000,      364658.0000000000,      70437.5555555555,
      9893.5555555556,      6962.0000000000,      7040.8888888889,
      2.0000000000,      18.0000000000,      2130048.0000000000,
      3.5555555556,      5066.8888888889,      0.8888888889,
      1373929.5555555555,      68.2222222222,      23184.8888888889,
      7771.5555555556,      722.6666666667,      2090.8888888889,
      13888.8888888889,      9430.2222222222,      684.6666666667,
      968.6666666667,      14.2222222222,      2888.0000000000,
      2.0000000000,      747.5555555556,      3.5555555556,
      0.2222222222,      0.0448140000,      43.5555555556,
      2112.6666666667,      501.5555555556,      2664.6666666667,
      722.6666666667,      102.8888888889,      18.0000000000,
      2.8888888889,      37.5555555556,      0.2222222222,
      2.8888888889,      88.8888888889,      16.2222222222,
      11.5555555556,      64.8888888889,      32.0000000000,
      0.2222222222,      27.5555555556,      338.6666666667,
      98.6666666667,      0.2222222222,      0.6666666667,
      14.0000000000,      1.5555555556,      0.2222222222,
      1.5555555556,      0.0448140000,      5688.8888888889,
      0.0448140000,      0.0448140000,      0.2222222222,
      0.0448140000,      1800.0000000000,      264.6666666667,
      13448.0000000000,      6612.6666666667,      36810.8888888889,
      1760.2222222222,      40.6666666667,      72326.8888888889,
      8844.6666666667,      56.8888888889,      304.2222222222,
      709.5555555556,      4933.5555555556,      19339.5555555556,
      9568.2222222222,      16.2222222222,      18.6666666667,
      7120.2222222222,      1963.5555555556,      29444.2222222222,
      2964.6666666667,      3.5555555556,      2888.6666666667,
      501.5555555556,      98.6666666667,      5.5555555556,
      5.5555555556,      0.2222222222,      5.5555555556,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      10.7828475292,      4.5428635982,      10.7828475292,
      4.5428635982,      10.7828475292,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      32.3485425877,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      23.5656950585,      4.5428635982,
      5.5428635982,      565.1423764617,      4.5428635982,
      4.5428635982,      13393.8276849491,      6094.7431589589,
      2512.1808286684,      2081.5640126745,      2091.3468602037,
      32.3485425877,      102.0456277631,      33410.6959505094,
      48.1313901169,      1762.2099769144,      29.5656950585,
      26940.5519071068,      301.9164745085,      3503.2400641064,
      2084.1402987290,      723.8884630274,      1154.6028770024,
      2750.3785489752,      2237.5999243556,      638.5163862857,
      728.8978105589,      87.2627802339,      1347.2446183327,
      38.3485425877,      680.4051566956,      48.1313901169,
      10.4495141959,      4.5428635982,      163.2931987426,
      1027.3665417209,      540.9317822552,      1171.7564483644,
      631.8884630274,      253.3409287145,      97.0456277631,
      40.8077421452,      149.1770178800,      10.7828475292,
      38.8077421452,      215.6569505847,      101.0993538448,
      93.6154842904,      186.1987076895,      133.3941703508,
      10.4495141959,      126.9823559224,      443.9199458525,
      239.1611577385,      16.7828475292,      19.5217392325,
      91.2946963403,      29.0982321134,      10.4495141959,
      28.4315654468,      4.5428635982,      1869.2556046775,
      4.5428635982,      4.5428635982,      11.7828475292,
      4.5428635982,      1060.4562776311,      392.1181809299,
      2816.5804921916,      2051.0631903519,      4742.6189443984,
      980.6734301019,      171.8491581621,      6167.6211649736,
      2349.1970973702,      173.5255604677,      405.9653585817,
      651.2980242518,      1767.6442818559,      3481.9914588886,
      2405.4591444911,      129.0993538448,      99.7163290932,
      2161.1297077329,      1061.5876677480,      4240.9981879638,
      1424.4517339080,      55.1313901169,      1374.3777182949,
      528.2651155885,      246.1611577385,      56.9142376462,
      53.9142376462,      10.7828475292,      53.9142376462,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_10, trained with 4 samples
exploit_kit_data_entry caws_10 = {
   .mean = {
      12.0000000000,      3.0000000000,      60.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      2.0000000000,      3.0000000000,
      0.0000000000,      0.0000000000,      7.0000000000,
      1.0000000000,      49.0000000000,      0.0000000000,
      0.0000000000,      2.0000000000,      0.0000000000,
      0.0000000000,      24.0000000000,      0.0000000000,
      29.0000000000,      50.0000000000,      4.0000000000,
      1.0000000000,      800.0000000000,      63.0000000000,
      92.0000000000,      263.0000000000,      263.0000000000,
      3.0000000000,      139.0000000000,      90.0000000000,
      19.0000000000,      144.0000000000,      18.0000000000,
      231.2500000000,      170.2500000000,      193.7500000000,
      136.5000000000,      195.7500000000,      174.0000000000,
      132.0000000000,      126.2500000000,      104.7500000000,
      100.5000000000,      25.0000000000,      230.0000000000,
      28.0000000000,      272.0000000000,      20.0000000000,
      8.0000000000,      0.0000000000,      16.7500000000,
      5.7500000000,      21.2500000000,      1.7500000000,
      9.5000000000,      14.5000000000,      1.0000000000,
      3.0000000000,      5.7500000000,      0.0000000000,
      0.7500000000,      10.2500000000,      5.7500000000,
      1.7500000000,      8.5000000000,      1.7500000000,
      1.0000000000,      4.5000000000,      9.5000000000,
      4.5000000000,      0.2500000000,      3.2500000000,
      3.7500000000,      5.0000000000,      0.7500000000,
      2.0000000000,      22.0000000000,      5.0000000000,
      22.0000000000,      0.0000000000,      10.0000000000,
      0.0000000000,      714.5000000000,      359.2500000000,
      288.7500000000,      329.7500000000,      864.5000000000,
      583.7500000000,      112.7500000000,      130.0000000000,
      232.2500000000,      15.0000000000,      34.2500000000,
      271.7500000000,      110.7500000000,      282.2500000000,
      144.5000000000,      60.7500000000,      8.2500000000,
      359.0000000000,      163.5000000000,      309.0000000000,
      891.7500000000,      154.7500000000,      63.2500000000,
      96.2500000000,      59.0000000000,      32.5000000000,
      109.0000000000,      8.0000000000,      109.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      1.6875000000,      0.6875000000,      2.1875000000,
      1.2500000000,      1.1875000000,      0.0448140000,
      0.5000000000,      0.1875000000,      0.1875000000,
      1.2500000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      1.6875000000,
      0.6875000000,      1.6875000000,      0.6875000000,
      0.7500000000,      0.2500000000,      0.0448140000,
      0.5000000000,      0.1875000000,      0.0448140000,
      0.1875000000,      0.6875000000,      0.6875000000,
      1.6875000000,      0.7500000000,      1.6875000000,
      0.5000000000,      0.7500000000,      0.7500000000,
      0.7500000000,      0.1875000000,      0.6875000000,
      1.6875000000,      3.5000000000,      0.1875000000,
      3.5000000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.2500000000,      0.1875000000,
      0.1875000000,      0.6875000000,      0.2500000000,
      0.1875000000,      3.1875000000,      0.5000000000,
      1.1875000000,      0.0448140000,      0.6875000000,
      0.6875000000,      0.6875000000,      0.6875000000,
      0.2500000000,      0.1875000000,      0.6875000000,
      0.5000000000,      0.2500000000,      2.0000000000,
      0.1875000000,      3.1875000000,      0.6875000000,
      1.1875000000,      0.5000000000,      0.2500000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      16.5428635982,      7.5428635982,      64.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      6.5428635982,      7.5428635982,
      4.5428635982,      4.5428635982,      11.5428635982,
      5.5428635982,      53.5428635982,      4.5428635982,
      4.5428635982,      6.5428635982,      4.5428635982,
      4.5428635982,      28.5428635982,      4.5428635982,
      33.5428635982,      54.5428635982,      8.5428635982,
      5.5428635982,      804.5428635982,      67.5428635982,
      96.5428635982,      267.5428635982,      267.5428635982,
      7.5428635982,      143.5428635982,      94.5428635982,
      23.5428635982,      148.5428635982,      22.5428635982,
      259.1269164164,      188.0434103051,      225.4892655584,
      160.4926295609,      219.1351226122,      178.5428635982,
      147.1742712939,      135.5423054721,      114.0423054721,
      124.4926295609,      29.5428635982,      234.5428635982,
      32.5428635982,      276.5428635982,      24.5428635982,
      12.5428635982,      4.5428635982,      44.6269164164,
      23.5434103051,      49.1269164164,      19.5434103051,
      28.0846109442,      25.2298301314,      5.5428635982,
      18.1742712939,      15.0423054721,      4.5428635982,
      10.0423054721,      28.0434103051,      23.5434103051,
      29.6269164164,      27.0846109442,      29.6269164164,
      16.1742712939,      23.0846109442,      28.0846109442,
      23.0846109442,      9.5423054721,      21.0434103051,
      31.6269164164,      45.1473481702,      10.0423054721,
      42.1473481702,      26.5428635982,      9.5428635982,
      26.5428635982,      4.5428635982,      14.5428635982,
      4.5428635982,      725.2298301314,      368.5423054721,
      298.0423054721,      347.5434103051,      875.2298301314,
      593.0423054721,      151.0631569671,      145.1742712939,
      255.6351226122,      19.5428635982,      52.0434103051,
      289.5434103051,      128.5434103051,      300.0434103051,
      155.2298301314,      70.0423054721,      26.0434103051,
      374.1742712939,      174.2298301314,      339.3485425877,
      901.0423054721,      193.0631569671,      81.0434103051,
      119.6351226122,      74.1742712939,      43.2298301314,
      113.5428635982,      12.5428635982,      113.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_11, trained with 6 samples
exploit_kit_data_entry caws_11 = {
   .mean = {
      2.0000000000,      0.0000000000,      1.6666666667,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      18.3333333333,      0.0000000000,
      0.1666666667,      12.0000000000,      0.0000000000,
      0.0000000000,      876.6666666667,      37.6666666667,
      0.3333333333,      118.3333333333,      118.3333333333,
      2.6666666667,      19.6666666667,      4.3333333333,
      12.0000000000,      15.0000000000,      2.6666666667,
      118.8333333333,      94.8333333333,      361.8333333333,
      234.6666666667,      122.5000000000,      164.3333333333,
      296.0000000000,      212.5000000000,      84.8333333333,
      79.0000000000,      0.6666666667,      0.0000000000,
      2.5000000000,      60.0000000000,      3.1666666667,
      0.0000000000,      0.0000000000,      11.1666666667,
      88.8333333333,      73.1666666667,      74.1666666667,
      76.3333333333,      38.0000000000,      0.6666666667,
      0.6666666667,      15.8333333333,      0.0000000000,
      3.1666666667,      0.8333333333,      2.1666666667,
      10.5000000000,      11.6666666667,      11.1666666667,
      0.6666666667,      12.6666666667,      6.6666666667,
      15.3333333333,      1.1666666667,      3.8333333333,
      2.1666666667,      1.3333333333,      15.1666666667,
      1.3333333333,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      99.6666666667,      18.5000000000,
      56.1666666667,      68.5000000000,      182.6666666667,
      51.8333333333,      30.5000000000,      48.0000000000,
      116.5000000000,      10.1666666667,      8.1666666667,
      22.1666666667,      49.1666666667,      119.5000000000,
      57.3333333333,      53.8333333333,      0.8333333333,
      127.0000000000,      48.5000000000,      109.0000000000,
      51.1666666667,      28.1666666667,      20.1666666667,
      16.8333333333,      13.3333333333,      1.3333333333,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.8888888889,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.8888888889,      0.0448140000,
      0.1388888889,      8.0000000000,      0.0448140000,
      0.0448140000,      384272.2222222222,      174.2222222222,
      0.2222222222,      43.5555555556,      43.5555555556,
      0.8888888889,      0.8888888889,      3.5555555556,
      3.3333333333,      18.0000000000,      3.5555555556,
      1293.1388888889,      678.8055555556,      57744.8055555556,
      21563.5555555556,      5253.9166666667,      11755.5555555556,
      37538.3333333333,      18721.2500000000,      2725.8055555556,
      2245.3333333333,      0.2222222222,      0.0448140000,
      4.5833333333,      2.0000000000,      2.8055555556,
      0.0448140000,      0.0448140000,      43.1388888889,
      3514.4722222222,      2324.4722222222,      2677.1388888889,
      1701.8888888889,      480.6666666667,      0.2222222222,
      0.5555555556,      8.8055555556,      0.0448140000,
      5.1388888889,      0.8055555556,      4.4722222222,
      4.2500000000,      3.2222222222,      1.8055555556,
      0.5555555556,      7.2222222222,      7.2222222222,
      1.8888888889,      0.1388888889,      5.4722222222,
      1.8055555556,      3.2222222222,      115.1388888889,
      3.2222222222,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      1701.5555555556,      0.2500000000,
      147.4722222222,      15.5833333333,      76.2222222222,
      19.1388888889,      302.2500000000,      72.3333333333,
      0.9166666667,      2.8055555556,      9.1388888889,
      26.1388888889,      142.1388888889,      10.5833333333,
      0.2222222222,      793.4722222222,      0.8055555556,
      18.3333333333,      0.2500000000,      243.3333333333,
      86.8055555556,      44.1388888889,      2.8055555556,
      1.1388888889,      80.5555555556,      0.2222222222,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      6.5428635982,      4.5428635982,      21.8990283918,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      38.5656950585,      4.5428635982,
      8.1642098536,      72.6970851754,      4.5428635982,
      4.5428635982,      14179.4445009431,      320.9197308186,
      10.4495141959,      259.9598654093,      259.9598654093,
      22.8990283918,      39.8990283918,      44.7980567836,
      51.1798000079,      106.0456277631,      43.1313901169,
      890.5278750694,      653.9411142242,      5518.6216452589,
      3385.9178967076,      1677.9800028608,      2491.0549317239,
      4453.7687946584,      3148.7312978447,      1205.2260536437,
      1095.8648938906,      10.7828475292,      4.5428635982,
      48.4423878560,      90.3485425877,      39.1111527523,
      4.5428635982,      4.5428635982,      152.1141480091,
      1361.0260348240,      1107.7965606836,      1184.5125674949,
      961.6292144361,      508.4839851399,      10.7828475292,
      16.6617530406,      79.5130647363,      4.5428635982,
      51.8138226989,      20.0939678701,      47.5487605396,
      54.7402229769,      50.1879357403,      40.0022187051,
      16.6617530406,      70.3377707435,      64.3377707435,
      44.8268153179,      9.1642098536,      54.0334475054,
      31.0022187051,      39.8546024069,      245.4348100037,
      39.8546024069,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      984.8758461405,      29.2298301314,
      316.7687927208,      153.2135774625,      370.0209581274,
      145.7150890178,      403.5834609997,      230.5122763323,
      137.0460604589,      46.1111527523,      73.0404970177,
      131.8817667240,      305.0130606965,      189.3126429345,
      67.4495141959,      658.3227560024,      20.0939678701,
      218.8847757120,      59.2298301314,      443.7523580087,
      251.1052463412,      170.7384363666,      56.1111527523,
      39.7348117927,      205.9396787013,      11.4495141959,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_12, trained with 4 samples
exploit_kit_data_entry caws_12 = {
   .mean = {
      0.0000000000,      1.0000000000,      2.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      2.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      2.0000000000,      0.0000000000,
      0.0000000000,      32.5000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      2.2500000000,
      0.0000000000,      69.7500000000,      69.7500000000,
      0.0000000000,      63.7500000000,      32.2500000000,
      6.5000000000,      7.2500000000,      0.0000000000,
      131.7500000000,      64.7500000000,      68.0000000000,
      74.2500000000,      49.2500000000,      89.2500000000,
      84.0000000000,      56.7500000000,      35.7500000000,
      60.7500000000,      0.0000000000,      5.0000000000,
      2.5000000000,      8.5000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      18.0000000000,
      11.2500000000,      0.5000000000,      10.2500000000,
      0.2500000000,      2.7500000000,      2.2500000000,
      1.7500000000,      3.5000000000,      10.2500000000,
      10.2500000000,      4.7500000000,      7.0000000000,
      0.2500000000,      8.0000000000,      11.7500000000,
      0.0000000000,      8.2500000000,      0.2500000000,
      18.0000000000,      3.2500000000,      3.2500000000,
      4.5000000000,      3.2500000000,      4.0000000000,
      11.5000000000,      7.0000000000,      39.0000000000,
      7.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      4.7500000000,      9.0000000000,
      5.7500000000,      11.2500000000,      15.2500000000,
      17.2500000000,      8.7500000000,      1.0000000000,
      7.2500000000,      10.5000000000,      0.0000000000,
      7.5000000000,      4.7500000000,      9.2500000000,
      10.2500000000,      0.0000000000,      2.5000000000,
      35.7500000000,      1.7500000000,      27.7500000000,
      47.5000000000,      7.5000000000,      7.0000000000,
      1.0000000000,      3.0000000000,      6.5000000000,
      4.0000000000,      1.5000000000,      4.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      10.7500000000,      0.0448140000,
      0.0448140000,      0.0448140000,      3.1875000000,
      0.0448140000,      151.6875000000,      151.6875000000,
      0.0448140000,      183.6875000000,      1.1875000000,
      22.2500000000,      0.1875000000,      0.0448140000,
      451.1875000000,      267.1875000000,      219.5000000000,
      446.1875000000,      75.1875000000,      3163.6875000000,
      374.0000000000,      315.1875000000,      24.6875000000,
      63.1875000000,      0.0448140000,      0.0448140000,
      4.7500000000,      0.2500000000,      0.5000000000,
      0.0448140000,      0.0448140000,      737.0000000000,
      178.6875000000,      0.7500000000,      221.1875000000,
      0.1875000000,      3.1875000000,      6.1875000000,
      6.1875000000,      10.2500000000,      238.6875000000,
      59.1875000000,      9.6875000000,      61.0000000000,
      0.1875000000,      48.5000000000,      197.1875000000,
      0.0448140000,      188.1875000000,      0.1875000000,
      868.5000000000,      31.6875000000,      1.6875000000,
      22.2500000000,      2.1875000000,      15.5000000000,
      192.7500000000,      0.0448140000,      19.0000000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.6875000000,      193.5000000000,
      3.1875000000,      213.6875000000,      5.6875000000,
      203.1875000000,      21.6875000000,      0.0448140000,
      21.1875000000,      218.2500000000,      0.0448140000,
      12.2500000000,      30.6875000000,      3.1875000000,
      41.1875000000,      0.0448140000,      0.7500000000,
      712.6875000000,      1.6875000000,      163.6875000000,
      43.2500000000,      26.2500000000,      12.5000000000,
      1.5000000000,      2.0000000000,      40.2500000000,
      0.0448140000,      0.7500000000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      4.5428635982,      5.5428635982,      6.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      6.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      6.5428635982,      4.5428635982,
      4.5428635982,      102.8602014632,      4.5428635982,
      4.5428635982,      4.5428635982,      40.5631569671,
      4.5428635982,      334.0503504703,      334.0503504703,
      4.5428635982,      354.5956976712,      55.6351226122,
      107.7250150102,      16.5423054721,      4.5428635982,
      587.5783913153,      415.5268391825,      385.9362917039,
      527.5456399923,      235.3282720682,      1296.2843554673,
      499.0100781378,      437.7345243571,      142.3755780601,
      231.3340529262,      4.5428635982,      9.5428635982,
      49.2702452243,      19.2298301314,      16.1742712939,
      4.5428635982,      4.5428635982,      600.5813614486,
      298.1099567051,      19.0846109442,      329.4060872854,
      9.5423054721,      41.0631569671,      55.6302309154,
      55.1302309154,      72.2044353782,      341.7913335872,
      175.3464900848,      71.5426539200,      174.6053046133,
      9.5423054721,      157.4492402190,      313.0939888316,
      4.5428635982,      302.6367293843,      9.5423054721,
      650.4231420916,      124.0499711376,      31.1269164164,
      105.7250150102,      34.9892655584,      88.4867669418,
      309.4339781477,      11.5428635982,      132.5404904487,
      11.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      22.5434103051,      307.5130534815,
      44.0631569671,      324.9484705284,      66.4280279347,
      323.1442655830,      108.6872945444,      5.5428635982,
      106.0285621052,      327.5297136061,      4.5428635982,
      82.6088109201,      123.6285767422,      47.5631569671,
      147.9727094692,      4.5428635982,      21.0846109442,
      608.6415453143,      29.6269164164,      302.3057857374,
      188.6288810074,      117.4480410840,      82.8713564693,
      27.2826088488,      33.3485425877,      142.6462816187,
      8.5428635982,      20.0846109442,      8.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_13, trained with 4 samples
exploit_kit_data_entry caws_13 = {
   .mean = {
      2.0000000000,      0.0000000000,      5.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      2.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      2.0000000000,      0.0000000000,
      1.0000000000,      26.5000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      3.2500000000,
      0.0000000000,      47.0000000000,      47.0000000000,
      0.0000000000,      41.5000000000,      30.0000000000,
      2.0000000000,      9.0000000000,      0.0000000000,
      122.2500000000,      62.7500000000,      55.5000000000,
      51.5000000000,      52.5000000000,      39.5000000000,
      66.0000000000,      62.7500000000,      33.0000000000,
      53.5000000000,      0.0000000000,      8.5000000000,
      2.7500000000,      10.5000000000,      3.2500000000,
      0.0000000000,      0.0000000000,      8.0000000000,
      5.5000000000,      3.5000000000,      0.0000000000,
      2.2500000000,      14.7500000000,      8.2500000000,
      1.0000000000,      8.0000000000,      2.5000000000,
      0.5000000000,      4.5000000000,      1.2500000000,
      3.7500000000,      5.5000000000,      4.0000000000,
      3.5000000000,      3.0000000000,      10.0000000000,
      2.2500000000,      4.2500000000,      1.0000000000,
      7.5000000000,      5.5000000000,      1.5000000000,
      2.2500000000,      8.0000000000,      43.7500000000,
      8.0000000000,      1.0000000000,      0.0000000000,
      0.0000000000,      8.0000000000,      3.2500000000,
      9.2500000000,      2.7500000000,      12.5000000000,
      11.5000000000,      8.2500000000,      0.0000000000,
      19.2500000000,      4.5000000000,      2.5000000000,
      4.0000000000,      6.0000000000,      17.5000000000,
      10.0000000000,      4.0000000000,      12.2500000000,
      20.2500000000,      2.5000000000,      14.0000000000,
      54.5000000000,      5.5000000000,      3.5000000000,
      5.7500000000,      4.5000000000,      6.0000000000,
      3.0000000000,      2.5000000000,      3.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      84.7500000000,      0.0448140000,
      0.0448140000,      0.0448140000,      3.1875000000,
      0.0448140000,      6.5000000000,      6.5000000000,
      0.0448140000,      35.2500000000,      1.0000000000,
      3.0000000000,      0.0448140000,      0.0448140000,
      233.1875000000,      57.6875000000,      85.2500000000,
      208.2500000000,      81.2500000000,      10.2500000000,
      46.5000000000,      246.6875000000,      28.5000000000,
      127.2500000000,      0.0448140000,      0.2500000000,
      3.1875000000,      0.2500000000,      3.6875000000,
      0.0448140000,      0.0448140000,      96.5000000000,
      54.7500000000,      10.7500000000,      0.0448140000,
      5.1875000000,      145.6875000000,      77.1875000000,
      3.0000000000,      46.0000000000,      10.7500000000,
      0.7500000000,      8.7500000000,      1.6875000000,
      2.1875000000,      90.7500000000,      6.0000000000,
      4.7500000000,      11.0000000000,      27.5000000000,
      15.1875000000,      7.1875000000,      3.0000000000,
      72.7500000000,      54.7500000000,      2.7500000000,
      3.1875000000,      0.0448140000,      7.6875000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      6.0000000000,      3.6875000000,
      88.6875000000,      3.6875000000,      36.7500000000,
      42.7500000000,      32.1875000000,      0.0448140000,
      173.1875000000,      24.7500000000,      6.7500000000,
      6.0000000000,      14.0000000000,      46.2500000000,
      26.0000000000,      10.0000000000,      150.1875000000,
      130.6875000000,      6.7500000000,      38.5000000000,
      31.2500000000,      0.7500000000,      6.7500000000,
      99.1875000000,      16.2500000000,      18.0000000000,
      0.0448140000,      3.2500000000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      6.5428635982,      4.5428635982,      9.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      6.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      6.5428635982,      4.5428635982,
      5.5428635982,      224.0571242103,      4.5428635982,
      4.5428635982,      4.5428635982,      41.5631569671,
      4.5428635982,      101.7116132178,      101.7116132178,
      4.5428635982,      168.9096735166,      51.4596602629,
      39.1692218885,      13.5428635982,      4.5428635982,
      449.9492710924,      225.7410289262,      253.6390315802,
      361.1815608382,      245.9347635797,      108.2044353782,
      212.3353729105,      399.8016162631,      147.5632359445,
      295.5760017364,      4.5428635982,      19.2298301314,
      41.0631569671,      21.2298301314,      44.4586945448,
      4.5428635982,      4.5428635982,      218.8077140305,
      164.2869855129,      73.8602014632,      4.5428635982,
      51.1267023640,      273.7704106767,      196.7868859749,
      38.1692218885,      153.5464972287,      72.8602014632,
      19.0846109442,      67.9785311167,      29.1269164164,
      35.4892655584,      209.9307203867,      56.5652176976,
      50.2702452243,      74.1736412205,      122.5354078122,
      85.8807492491,      61.7823045878,      38.1692218885,
      190.5371904916,      164.2869855129,      37.0868206103,
      40.5631569671,      12.5428635982,      103.2497863902,
      12.5428635982,      5.5428635982,      4.5428635982,
      4.5428635982,      60.5652176976,      44.4586945448,
      211.3442925641,      43.9586945448,      142.5922766097,
      151.8107356730,      129.9992978877,      4.5428635982,
      301.6606781950,      111.2604618308,      58.2538328327,
      56.5652176976,      86.2946963403,      163.4414680966,
      119.4232264356,      71.8614042442,      275.2403034920,
      265.5739039884,      58.2538328327,      147.1536902082,
      174.4631478047,      24.0846109442,      59.2538328327,
      219.4730258589,      91.0066561152,      97.0456277631,
      7.5428635982,      41.1869527159,      7.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_14, trained with 1 samples
exploit_kit_data_entry caws_14 = {
   .mean = {
      1.0000000000,      0.0000000000,      2.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      6.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      176.0000000000,      5.0000000000,      32.0000000000,
      0.0000000000,      3.0000000000,      12.0000000000,
      5.0000000000,      4.0000000000,      0.0000000000,
      184.0000000000,      26.0000000000,      88.0000000000,
      2.0000000000,      3.0000000000,      2.0000000000,
      1.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      5.0000000000,      22.0000000000,
      1.0000000000,      7.0000000000,      0.0000000000,
      0.0000000000,      8.0000000000,      7.0000000000,
      0.0000000000,      13.0000000000,      1.0000000000,
      0.0000000000,      12.0000000000,      3.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      3.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      3.0000000000,
      0.0000000000,      0.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      3.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      4.0000000000,      1.0000000000,      0.0000000000,
      1.0000000000,      25.0000000000,      3.0000000000,
      28.0000000000,      18.0000000000,      12.0000000000,
      20.0000000000,      59.0000000000,      4.0000000000,
      9.0000000000,      9.0000000000,      17.0000000000,
      22.0000000000,      26.0000000000,      14.0000000000,
      20.0000000000,      42.0000000000,      11.0000000000,
      18.0000000000,      1.0000000000,      10.0000000000,
      6.0000000000,      32.0000000000,      10.0000000000,
      0.0000000000,      0.0000000000,      1.0000000000,
      6.0000000000,      0.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      5.5428635982,      4.5428635982,      6.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      10.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      180.5428635982,      9.5428635982,      36.5428635982,
      4.5428635982,      7.5428635982,      16.5428635982,
      9.5428635982,      8.5428635982,      4.5428635982,
      188.5428635982,      30.5428635982,      92.5428635982,
      6.5428635982,      7.5428635982,      6.5428635982,
      5.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      9.5428635982,      26.5428635982,
      5.5428635982,      11.5428635982,      4.5428635982,
      4.5428635982,      12.5428635982,      11.5428635982,
      4.5428635982,      17.5428635982,      5.5428635982,
      4.5428635982,      16.5428635982,      7.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      7.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      7.5428635982,
      4.5428635982,      4.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      7.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      8.5428635982,      5.5428635982,      4.5428635982,
      5.5428635982,      29.5428635982,      7.5428635982,
      32.5428635982,      22.5428635982,      16.5428635982,
      24.5428635982,      63.5428635982,      8.5428635982,
      13.5428635982,      13.5428635982,      21.5428635982,
      26.5428635982,      30.5428635982,      18.5428635982,
      24.5428635982,      46.5428635982,      15.5428635982,
      22.5428635982,      5.5428635982,      14.5428635982,
      10.5428635982,      36.5428635982,      14.5428635982,
      4.5428635982,      4.5428635982,      5.5428635982,
      10.5428635982,      4.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_15, trained with 2 samples
exploit_kit_data_entry caws_15 = {
   .mean = {
      0.0000000000,      0.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      34.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      7.0000000000,
      80.0000000000,      84.0000000000,      84.0000000000,
      0.0000000000,      95.5000000000,      122.5000000000,
      21.5000000000,      42.5000000000,      7.0000000000,
      591.0000000000,      129.0000000000,      152.0000000000,
      191.0000000000,      150.0000000000,      174.5000000000,
      257.0000000000,      198.5000000000,      97.0000000000,
      162.0000000000,      2.0000000000,      4.0000000000,
      25.5000000000,      16.0000000000,      11.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      2.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      2.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      2.0000000000,      0.0000000000,      0.0000000000,
      7.5000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      3.0000000000,      244.0000000000,
      3.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      4.0000000000,      6.0000000000,
      3.0000000000,      6.0000000000,      45.5000000000,
      43.0000000000,      24.0000000000,      0.5000000000,
      0.0000000000,      0.0000000000,      4.5000000000,
      1.5000000000,      1.5000000000,      1.0000000000,
      2.0000000000,      0.5000000000,      1.5000000000,
      21.0000000000,      2.5000000000,      41.5000000000,
      247.5000000000,      3.5000000000,      3.0000000000,
      3.5000000000,      0.0000000000,      0.5000000000,
      0.0000000000,      4.5000000000,      0.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      4.0000000000,
      0.0448140000,      1.0000000000,      1.0000000000,
      0.0448140000,      2.2500000000,      2.2500000000,
      42.2500000000,      0.2500000000,      0.0448140000,
      27889.0000000000,      4.0000000000,      121.0000000000,
      25.0000000000,      1764.0000000000,      6.2500000000,
      484.0000000000,      7832.2500000000,      100.0000000000,
      36.0000000000,      0.0448140000,      0.0448140000,
      56.2500000000,      0.0448140000,      1.0000000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      4.0000000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      4.0000000000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      4.0000000000,      0.0448140000,      0.0448140000,
      56.2500000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      7056.0000000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      1.0000000000,      0.0448140000,
      1.0000000000,      4.0000000000,      20.2500000000,
      4.0000000000,      441.0000000000,      0.2500000000,
      0.0448140000,      0.0448140000,      0.2500000000,
      2.2500000000,      0.2500000000,      0.0448140000,
      0.0448140000,      0.2500000000,      2.2500000000,
      400.0000000000,      6.2500000000,      1560.2500000000,
      6642.2500000000,      2.2500000000,      9.0000000000,
      6.2500000000,      0.0448140000,      0.2500000000,
      0.0448140000,      20.2500000000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      4.5428635982,      4.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      38.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      49.9193205258,
      84.5428635982,      105.4596602629,      105.4596602629,
      4.5428635982,      127.6894903943,      154.6894903943,
      160.9877917088,      53.2298301314,      11.5428635982,
      4174.7632639032,      171.9193205258,      388.0562628918,
      298.2983013145,      1051.3057310415,      228.1491506572,
      729.1125257837,      2097.6799332661,      311.5966026289,
      290.7579615774,      6.5428635982,      8.5428635982,
      186.4474519717,      20.5428635982,      32.4596602629,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      44.9193205258,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      44.9193205258,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      44.9193205258,      4.5428635982,      4.5428635982,
      168.4474519717,      4.5428635982,      4.5428635982,
      4.5428635982,      7.5428635982,      2046.6114620831,
      7.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      25.4596602629,      10.5428635982,
      24.4596602629,      48.9193205258,      142.0684711830,
      85.9193205258,      474.6528655208,      11.2298301314,
      4.5428635982,      4.5428635982,      15.2298301314,
      33.6894903943,      12.2298301314,      5.5428635982,
      6.5428635982,      11.2298301314,      33.6894903943,
      450.1932052579,      56.1491506572,      889.1565803843,
      1996.4623114258,      35.6894903943,      67.3789807887,
      57.1491506572,      4.5428635982,      11.2298301314,
      4.5428635982,      101.0684711830,      4.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_16, trained with 7 samples
exploit_kit_data_entry caws_16 = {
   .mean = {
      0.0000000000,      0.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      36.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      12.0000000000,
      78.0000000000,      81.7142857143,      81.7142857143,
      0.0000000000,      89.5714285714,      120.0000000000,
      16.5714285714,      12.5714285714,      6.8571428571,
      176.0000000000,      135.2857142857,      142.4285714286,
      161.8571428571,      114.1428571429,      125.0000000000,
      151.1428571429,      133.2857142857,      119.8571428571,
      128.5714285714,      2.0000000000,      3.8571428571,
      15.7142857143,      16.2857142857,      16.7142857143,
      0.0000000000,      0.0000000000,      5.8571428571,
      0.5714285714,      0.0000000000,      0.0000000000,
      3.0000000000,      1.2857142857,      0.0000000000,
      6.0000000000,      0.0000000000,      11.8571428571,
      0.5714285714,      0.7142857143,      2.0000000000,
      18.1428571429,      0.0000000000,      6.4285714286,
      0.5714285714,      7.7142857143,      17.2857142857,
      1.7142857143,      7.1428571429,      0.5714285714,
      1.1428571429,      1.4285714286,      0.0000000000,
      13.1428571429,      31.7142857143,      30.8571428571,
      31.7142857143,      0.0000000000,      0.0000000000,
      0.0000000000,      7.4285714286,      3.8571428571,
      12.4285714286,      5.7142857143,      2.5714285714,
      8.4285714286,      6.8571428571,      2.7142857143,
      7.8571428571,      1.8571428571,      1.5714285714,
      1.1428571429,      3.2857142857,      13.4285714286,
      8.7142857143,      6.2857142857,      1.2857142857,
      7.2857142857,      7.4285714286,      20.1428571429,
      44.0000000000,      1.7142857143,      6.7142857143,
      2.2857142857,      2.0000000000,      6.5714285714,
      0.0000000000,      9.5714285714,      0.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      24.0000000000,      0.0448140000,
      0.0448140000,      0.0448140000,      58.8571428571,
      24.0000000000,      23.6326530612,      23.6326530612,
      0.0448140000,      31.3877551020,      50.2857142857,
      12.2448979592,      281.9591836735,      0.1224489796,
      7692.2857142857,      759.0612244898,      533.1020408163,
      421.5510204082,      449.5510204082,      324.0000000000,
      945.8367346939,      522.2040816327,      440.9795918367,
      582.8163265306,      0.0448140000,      0.1224489796,
      8.7755102041,      1.9183673469,      6.4897959184,
      0.0448140000,      0.0448140000,      205.8367346939,
      1.9591836735,      0.0448140000,      0.0448140000,
      9.7142857143,      9.9183673469,      0.0448140000,
      216.0000000000,      0.0448140000,      351.5510204082,
      1.9591836735,      3.0612244898,      5.4285714286,
      393.5510204082,      0.0448140000,      201.1020408163,
      1.9591836735,      199.6326530612,      359.6326530612,
      9.9183673469,      194.9795918367,      1.9591836735,
      3.2653061224,      5.1020408163,      0.0448140000,
      325.2653061224,      341.6326530612,      2604.4081632653,
      341.6326530612,      0.0448140000,      0.0448140000,
      0.0448140000,      4.2448979592,      2.1224489796,
      180.8163265306,      21.6326530612,      2.5306122449,
      171.6734693878,      217.8367346939,      8.4897959184,
      182.1224489796,      6.1224489796,      2.5306122449,
      2.1224489796,      10.2040816327,      245.9591836735,
      178.7755102041,      212.7755102041,      5.6326530612,
      178.4897959184,      192.2448979592,      727.5510204082,
      2289.1428571429,      0.4897959184,      208.4897959184,
      1.6326530612,      3.1428571429,      210.2448979592,
      0.0448140000,      26.5306122449,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      4.5428635982,      4.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      141.1304353951,      4.5428635982,
      4.5428635982,      4.5428635982,      176.6350993920,
      183.1304353951,      186.0370489510,      186.0370489510,
      4.5428635982,      209.7986941982,      272.1756459522,
      91.6645967108,      372.9143244801,      14.3664596711,
      2058.1340237489,      726.5222253674,      637.9107229191,
      602.4606143660,      569.1438413466,      511.2738847321,
      811.1230940761,      623.6772586394,      570.4995808227,
      646.6417298671,      6.5428635982,      11.3664596711,
      79.2852837863,      46.0084465153,      71.3829373132,
      4.5428635982,      4.5428635982,      313.7391322286,
      30.6086958272,      4.5428635982,      4.5428635982,
      69.8849302531,      68.8695656112,      4.5428635982,
      321.3913061854,      4.5428635982,      414.2192034490,
      30.6086958272,      38.2608697840,      51.9994952928,
      443.8621808585,      4.5428635982,      310.7489819680,
      30.6086958272,      310.9208723887,      424.2463477363,
      69.2981370397,      306.7950226953,      30.6086958272,
      39.9208024252,      49.9010030315,      4.5428635982,
      400.1702580193,      428.3597834119,      1126.0166209978,
      428.3597834119,      4.5428635982,      4.5428635982,
      4.5428635982,      51.6422316754,      35.1209218387,
      300.9922482971,      105.5251312780,      36.7092376143,
      289.6021020017,      323.5865598719,      65.2418436775,
      297.4611608265,      54.9560312693,      35.7092376143,
      32.4066361244,      71.8360844598,      349.9822669399,
      295.6448782932,      319.3140573954,      52.2163788657,
      293.9869327460,      304.9719249907,      598.9775717177,
      1070.7371833718,      16.7329193422,      316.5740914726,
      29.7058623554,      40.0439114880,      317.7327269100,
      4.5428635982,      120.1055791884,      4.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_17, trained with 24 samples
exploit_kit_data_entry caws_17 = {
   .mean = {
      2.7500000000,      0.2916666667,      1.1666666667,
      0.0000000000,      0.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.9166666667,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.0000000000,      25.5833333333,      0.0000000000,
      0.0000000000,      0.0000000000,      3.0000000000,
      13.0000000000,      15.0000000000,      15.0000000000,
      21.5000000000,      30.2500000000,      24.0000000000,
      8.0000000000,      3.9583333333,      26.3333333333,
      81.4583333333,      54.3750000000,      80.8750000000,
      39.5000000000,      30.6666666667,      48.3333333333,
      9.0833333333,      17.7083333333,      17.5833333333,
      48.8750000000,      2.0000000000,      33.0000000000,
      3.0000000000,      18.0000000000,      2.0000000000,
      1.0000000000,      0.0000000000,      52.6250000000,
      54.9166666667,      75.7500000000,      53.9166666667,
      28.2500000000,      59.6250000000,      83.0833333333,
      41.7500000000,      119.0000000000,      58.8333333333,
      46.9166666667,      41.1666666667,      51.9583333333,
      71.8750000000,      31.0416666667,      44.0833333333,
      51.1250000000,      57.0416666667,      58.8333333333,
      48.9583333333,      42.6250000000,      54.8333333333,
      68.2916666667,      57.3750000000,      74.9583333333,
      148.7083333333,      18.0416666667,      5.0000000000,
      18.0416666667,      0.0000000000,      0.0000000000,
      0.0000000000,      89.2083333333,      77.9166666667,
      111.1666666667,      114.7500000000,      59.9166666667,
      42.3750000000,      106.9583333333,      75.6250000000,
      103.0000000000,      42.5833333333,      62.9166666667,
      80.0833333333,      120.0416666667,      86.0000000000,
      66.6250000000,      53.9583333333,      25.6666666667,
      59.7500000000,      59.6666666667,      76.4166666667,
      41.3750000000,      36.3750000000,      45.1666666667,
      47.8750000000,      66.7083333333,      62.1666666667,
      12.0000000000,      2.0000000000,      12.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.3541666667,      0.2065972222,      0.9722222222,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.1597222222,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      5.1597222222,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      26.7500000000,      1.9375000000,      0.0448140000,
      0.0448140000,      0.2065972222,      23.8888888889,
      36.0815972222,      83.0677083333,      37.1093750000,
      75.4166666667,      14.0555555556,      24.1388888889,
      2.2430555556,      4.7065972222,      6.6597222222,
      35.9427083333,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      22.4010416667,
      52.7430555556,      57.1875000000,      53.4930555556,
      39.6041666667,      46.1510416667,      79.0763888889,
      35.6875000000,      54.5000000000,      38.0555555556,
      36.0763888889,      62.4722222222,      70.2899305556,
      74.1927083333,      22.2899305556,      41.4930555556,
      91.1927083333,      45.6232638889,      31.8055555556,
      95.4565972222,      51.1510416667,      109.3888888889,
      162.8732638889,      31.1510416667,      47.0399305556,
      112.7899305556,      0.2065972222,      0.0448140000,
      0.2065972222,      0.0448140000,      0.0448140000,
      0.0448140000,      103.3315972222,      66.7430555556,
      39.2222222222,      131.3541666667,      46.6597222222,
      45.3177083333,      63.6232638889,      94.5677083333,
      57.7500000000,      58.3263888889,      40.8263888889,
      69.1597222222,      142.6232638889,      50.1666666667,
      44.7343750000,      88.6232638889,      37.4722222222,
      46.9375000000,      37.5555555556,      87.6597222222,
      52.9843750000,      66.8177083333,      72.6388888889,
      71.8593750000,      36.7899305556,      69.0555555556,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      15.5210523224,      10.0457189952,      22.3261770389,
      4.5428635982,      4.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      10.4930762640,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      5.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      5.5428635982,      74.3289987260,      4.5428635982,
      4.5428635982,      4.5428635982,      7.5428635982,
      17.5428635982,      19.5428635982,      19.5428635982,
      132.4902259098,      60.1205829125,      28.5428635982,
      12.5428635982,      13.7123856619,      131.2201289215,
      210.3621330409,      249.9615368156,      211.6018095574,
      225.8616336213,      111.1205201430,      153.7675267594,
      41.2231101993,      64.2644083453,      72.9630717082,
      177.5304658071,      6.5428635982,      37.5428635982,
      7.5428635982,      22.5428635982,      6.5428635982,
      5.5428635982,      4.5428635982,      154.1930113118,
      210.7661924800,      238.0331383759,      210.8703619407,
      163.2995936959,      205.4102534160,      273.9131602805,
      169.9478981936,      277.4240433572,      191.2162286996,
      175.8111624876,      210.7824723070,      231.8741727054,
      256.7181898757,      132.3574717724,      182.3159569683,
      256.0537538625,      201.9909318075,      179.8581226094,
      258.6232745094,      196.1043966842,      279.2780814985,
      342.1637351504,      177.1480555450,      222.1408342448,
      376.6155130083,      27.7957189952,      9.5428635982,
      27.7957189952,      4.5428635982,      4.5428635982,
      4.5428635982,      307.3503950267,      253.2344152166,
      245.5634703511,      360.6988345446,      206.5031468292,
      186.8380607851,      278.1295803336,      284.3114612221,
      266.0792991893,      206.4744396105,      200.0343055439,
      258.5468564547,      376.3236212966,      237.9954070568,
      210.1552790490,      255.9794244714,      157.0310303961,
      206.7721669017,      191.1770178800,      277.3365360897,
      197.5806542105,      211.7907684796,      228.0640273514,
      229.7883451217,      196.8712663592,      240.4957404660,
      16.5428635982,      6.5428635982,      16.5428635982,
      4.5428635982,      4.5428635982,
   }
};

// Family: caws_18, trained with 10 samples
exploit_kit_data_entry caws_18 = {
   .mean = {
      3.0000000000,      0.4000000000,      1.1000000000,
      0.0000000000,      0.0000000000,      1.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.8000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.0000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      0.0000000000,
      1.0000000000,      26.4000000000,      0.0000000000,
      0.0000000000,      0.0000000000,      3.0000000000,
      13.0000000000,      15.0000000000,      15.0000000000,
      23.0000000000,      86.2000000000,      24.0000000000,
      8.0000000000,      3.8000000000,      49.8000000000,
      1604.4000000000,      379.0000000000,      729.5000000000,
      480.7000000000,      310.8000000000,      952.0000000000,
      100.5000000000,      518.6000000000,      141.9000000000,
      900.8000000000,      2.0000000000,      33.0000000000,
      3.0000000000,      18.0000000000,      2.0000000000,
      1.0000000000,      0.0000000000,      1280.0000000000,
      2047.0000000000,      1448.0000000000,      1309.1000000000,
      1098.7000000000,      843.5000000000,      2190.9000000000,
      948.7000000000,      3512.1000000000,      1166.8000000000,
      998.1000000000,      1196.6000000000,      1366.2000000000,
      893.7000000000,      644.0000000000,      615.7000000000,
      669.6000000000,      1235.5000000000,      2484.9000000000,
      721.0000000000,      1219.5000000000,      808.0000000000,
      769.4000000000,      760.1000000000,      1513.4000000000,
      1287.8000000000,      18.2000000000,      5.0000000000,
      18.2000000000,      0.0000000000,      0.0000000000,
      0.0000000000,      962.7000000000,      1038.2000000000,
      1113.2000000000,      1099.3000000000,      300.8000000000,
      227.2000000000,      3079.3000000000,      1273.2000000000,
      1224.8000000000,      768.9000000000,      1213.7000000000,
      1528.3000000000,      1040.4000000000,      498.1000000000,
      930.9000000000,      916.1000000000,      58.6000000000,
      227.2000000000,      1454.1000000000,      321.2000000000,
      906.1000000000,      315.9000000000,      1102.0000000000,
      557.4000000000,      1704.1000000000,      709.4000000000,
      12.0000000000,      2.0000000000,      12.0000000000,
      0.0000000000,      0.0000000000,
   },
   .var = {
      0.4000000000,      0.2400000000,      0.4900000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.3600000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      8.8400000000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      50.6000000000,      22.9600000000,      0.0448140000,
      0.0448140000,      0.3600000000,      61.5600000000,
      34.6400000000,      63.4000000000,      79.8500000000,
      222.4100000000,      312.9600000000,      402.6000000000,
      139.2500000000,      101.0400000000,      156.6900000000,
      1342.1600000000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,      871.6000000000,
      343.2000000000,      634.6000000000,      170.0900000000,
      397.4100000000,      39.2500000000,      436.2900000000,
      1323.4100000000,      174.2900000000,      156.7600000000,
      917.0900000000,      107.2400000000,      488.1600000000,
      31.8100000000,      138.6000000000,      29.8100000000,
      195.6400000000,      487.4500000000,      854.2900000000,
      133.6000000000,      102.2500000000,      345.0000000000,
      271.8400000000,      64.0900000000,      418.0400000000,
      610.3600000000,      0.3600000000,      0.0448140000,
      0.3600000000,      0.0448140000,      0.0448140000,
      0.0448140000,      213.6100000000,      192.7600000000,
      163.3600000000,      155.0100000000,      237.1600000000,
      60.5600000000,      716.4100000000,      176.5600000000,
      201.9600000000,      32.0900000000,      44.0100000000,
      2230.8100000000,      493.0400000000,      1662.0900000000,
      198.2900000000,      1020.0900000000,      30.2400000000,
      39.9600000000,      67.8900000000,      17.5600000000,
      92.8900000000,      498.0900000000,      354.0000000000,
      726.8400000000,      64.0900000000,      117.0400000000,
      0.0448140000,      0.0448140000,      0.0448140000,
      0.0448140000,      0.0448140000,
   },
   .precheck = {
      16.5722808488,      10.9130435395,      16.1217621840,
      4.5428635982,      4.5428635982,      5.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      14.6757961577,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      5.5428635982,      4.5428635982,      4.5428635982,
      4.5428635982,      4.5428635982,      4.5428635982,
      5.5428635982,      90.2041569525,      4.5428635982,
      4.5428635982,      4.5428635982,      7.5428635982,
      17.5428635982,      19.5428635982,      19.5428635982,
      175.6504541136,      189.0273832548,      28.5428635982,
      12.5428635982,      16.6757961577,      218.1728828076,
      1730.7024525663,      549.8706498471,      921.2610073376,
      800.7368574189,      690.4358862656,      1382.5858238352,
      353.7330840153,      734.3096186062,      410.5231777867,
      1686.9854244913,      6.5428635982,      37.5428635982,
      7.5428635982,      22.5428635982,      6.5428635982,
      5.5428635982,      4.5428635982,      1913.5508135980,
      2444.5543243170,      1988.5960599216,      1588.9737924377,
      1526.5014356700,      977.9443861974,      2639.1398577151,
      1729.3745977575,      3795.4081558508,      1435.4831737112,
      1647.9734896784,      1418.8292624173,      1840.3370981048,
      1014.7332448612,      896.6413639486,      732.8666007206,
      969.7592069530,      1709.2921703827,      3112.1280955273,
      969.0424836289,      1436.4973851265,      1206.5954984901,
      1123.2176738603,      931.8979502846,      1952.1647826057,
      1817.9708851606,      31.0757961577,      9.5428635982,
      31.0757961577,      4.5428635982,      4.5428635982,
      4.5428635982,      1276.3415794229,      1336.1417065553,
      1387.4809875990,      1366.4792339479,      631.2787680486,
      394.1997324739,      3653.6857565211,      1558.3471283457,
      1529.7688788651,      890.4647610405,      1356.0634573496,
      2541.8709004605,      1516.9011131676,      1372.9832673236,
      1233.0852405694,      1601.4968233822,      176.6086210513,
      362.8549301102,      1630.9177038440,      411.1259631397,
      1112.9270433421,      794.8351958187,      1505.7610984035,
      1135.9518039021,      1875.8979502846,      941.5613918308,
      16.5428635982,      6.5428635982,      16.5428635982,
      4.5428635982,      4.5428635982,
   }
};

exploit_kit_data_entry *exploit_kit_data[NUM_EXPLOIT_CLASSES] = {
   &caws_1,
   &caws_2,
   &caws_3,
   &caws_4,
   &caws_5,
   &caws_6,
   &caws_7,
   &caws_8,
   &caws_9,
   &caws_10,
   &caws_11,
   &caws_12,
   &caws_13,
   &caws_14,
   &caws_15,
   &caws_16,
   &caws_17,
   &caws_18,
};

#endif /* RBF_CLASSIFIER_H */
