/*
 * This code was automatically generated by the Sourcefire VRT Rules2C web generator
 *
 * We make no claims to the correctness or fitness of the code generated or of modifications
 * to the generated code.
 *
 * Use at your own risk.
 *
 * Please report any problems with this tool to research@sourcefire.com
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

/* declare detection functions */
int rule17242eval(void *p);

/* declare rule data structures */
/* flowbits:isset "file.wmv"; */
static FlowBitsInfo rule17242flowbits0 =
{
    "file.wmv",
    FLOWBIT_ISSET,
    0,
};

static FlowBitsInfo rule17242flowbits1 =
{
    "file.wma",
    FLOWBIT_ISSET,
    0,
};

static FlowBitsInfo rule17242flowbits2 =
{
    "file.asf",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule17242option0 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule17242flowbits0
    }
};

static RuleOption rule17242option5 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule17242flowbits1
    }
};

static RuleOption rule17242option6 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule17242flowbits2
    }
};

/* flow:established, to_client; */
static FlowFlags rule17242flow1 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule17242option1 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule17242flow1
    }
};
#ifndef CONTENT_FAST_PATTERN
#define CONTENT_FAST_PATTERN 0
#endif
// content:"|C0 EF 19 BC|M[|CF 11 A8 FD 00 80|_|5C|D+", payload raw, depth 0, fast_pattern; 
static ContentInfo rule17242content2 = 
{
    (uint8_t *) "|C0 EF 19 BC|M[|CF 11 A8 FD 00 80|_|5C|D+", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_RAW, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule17242option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17242content2
    }
};
// content:"|91 07 DC B7 B7 A9 CF 11 8E E6 00 C0 0C| Se", payload raw, offset -40, depth 16, relative; 
static ContentInfo rule17242content3 = 
{
    (uint8_t *) "|91 07 DC B7 B7 A9 CF 11 8E E6 00 C0 0C| Se", /* pattern (now in snort content format) */
    16, /* depth */
    -40, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_RAW, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule17242option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17242content3
    }
};
// content:"MP4S", payload raw, offset 89, depth 4, relative; 
static ContentInfo rule17242content4 = 
{
    (uint8_t *) "MP4S", /* pattern (now in snort content format) */
    4, /* depth */
    89, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_RAW, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule17242option4 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule17242content4
    }
};

/* references for sid 17242 */
/* reference: cve "2010-0818"; */
static RuleReference rule17242ref1 = 
{
    "cve", /* type */
    "2010-0818" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS10-062"; */
static RuleReference rule17242ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS10-062" /* value */
};

static RuleReference *rule17242refs[] =
{
    &rule17242ref1,
    &rule17242ref2,
    NULL
};

/* metadata for sid 17242 */
/* metadata:service http, policy balanced-ips drop, policy security-ips drop; */
static RuleMetaData rule17242service1 = 
{
    "service http"
};

static RuleMetaData rule17242policy1 =
{
   "policy max-detect-ips drop"
};

static RuleMetaData *rule17242metadata[] =
{
    &rule17242service1,
    &rule17242policy1,
    NULL
};

RuleOption *rule17242options[] =
{
    &rule17242option0,
    &rule17242option1,
    &rule17242option2,
    &rule17242option3,
    &rule17242option4,
    &rule17242option5,
    &rule17242option6,
    NULL
};

Rule rule17242 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       17242, /* sigid */
       7, /* revision */
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "FILE-MULTIMEDIA Windows Media Player ASF file arbitrary code execution attempt",     /* message */
       rule17242refs /* ptr to references */
       ,rule17242metadata
   },
   rule17242options, /* ptr to rule options */
   &rule17242eval, /* replace with NULL to use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule17242eval(void *p) {
    const uint8_t *cursor_raw = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;
    
    const uint8_t *beg_of_payload, *end_of_payload;

    uint32_t imagewidth;
    uint32_t ifrmwidthsrc;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flowbits:isset "file.wmv";
    if (checkFlow(p, rule17242options[1]->option_u.flowFlags) > 0) {
            // flow:established, to_client;
        if (processFlowbits(p, rule17242options[0]->option_u.flowBit) > 0 ||
            processFlowbits(p, rule17242options[5]->option_u.flowBit) > 0 || 
            processFlowbits(p, rule17242options[6]->option_u.flowBit) > 0)    {
            // content:"|C0 EF 19 BC|M[|CF 11 A8 FD 00 80|_|5C|D+", payload raw, depth 0, fast_pattern;
            if (contentMatch(p, rule17242options[2]->option_u.content, &cursor_raw) > 0) {
                // content:"|91 07 DC B7 B7 A9 CF 11 8E E6 00 C0 0C| Se", payload raw, offset -40, depth 16, relative;
                if (contentMatch(p, rule17242options[3]->option_u.content, &cursor_raw) > 0) {
                    // content:"MP4S", payload raw, offset 89, depth 4, relative;
                    if (contentMatch(p, rule17242options[4]->option_u.content, &cursor_raw) > 0) {

                        if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
                            return RULE_NOMATCH;

                        //Check we have at least 28 bytes after the MP4S compression ID
                        if(cursor_raw + 35 > end_of_payload)
                            return RULE_NOMATCH;

                        //Here we extract imagewidth from the Video Media Type header
                        //We know we can track backwards 16 bytes since we've already
                        //matched on the stream type GUID and the header type GUID
                        imagewidth = read_little_32(cursor_raw-16);

                        //Extract ifrmwidthsrc. 20 bytes in, we have codec-specific data.
                        //ifrmwidthsrc is a 13-bit little-endian value starting at the 37th bit.
                        ifrmwidthsrc = (*(cursor_raw+32) & 0x07) << 10;
                        ifrmwidthsrc |= *(cursor_raw+33) << 2;
                        ifrmwidthsrc |= *(cursor_raw+34) >> 6;

                        //Match on the following two conditions
                        if (imagewidth < ifrmwidthsrc)
                            return RULE_MATCH;

                        if (imagewidth - ifrmwidthsrc > 0x10)
                            return RULE_MATCH;
                    }
                }
            }
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule17242,
    NULL
};
*/
