/*
 * This code was automatically generated by the Sourcefire VRT Rules2C web generator
 *
 * We make no claims to the correctness or fitness of the code generated or of modifications
 * to the generated code.
 *
 * Use at your own risk.
 *
 * Please report any problems with this tool to research@sourcefire.com
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

/* declare detection functions */
int rule16531eval(void *p);

/* declare rule data structures */
/* flow:established, to_client; */
static FlowFlags rule16531flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule16531option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule16531flow0
    }
};
#ifndef CONTENT_FAST_PATTERN
#define CONTENT_FAST_PATTERN 0
#endif
// content:"|FF|SMB2", payload raw, offset 4, depth 5, fast_pattern; 
static ContentInfo rule16531content1 = 
{
    (uint8_t *) "|FF|SMB2", /* pattern (now in snort content format) */
    5, /* depth */
    4, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule16531option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule16531content1
    }
};

/* references for sid 16531 */
/* reference: cve "2010-0270"; */
static RuleReference rule16531ref1 = 
{
    "cve", /* type */
    "2010-0270" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS10-020"; */
static RuleReference rule16531ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS10-020" /* value */
};
/* reference: cve "2011-0660"; */
static RuleReference rule16531ref3 =
{
    "cve", /* type */
    "2011-0660" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS11-019"; */
static RuleReference rule16531ref4 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS11-019" /* value */
};

/* reference: cve "2004-0949"; */
static RuleReference rule16531ref5 =
{
    "cve", /* type */
    "2004-0949" /* value */
};

static RuleReference *rule16531refs[] =
{
    &rule16531ref1,
    &rule16531ref2,
    &rule16531ref3,
    &rule16531ref4,
    &rule16531ref5,
    NULL
};
/* metadata for sid 16531 */
/* metadata:service netbios-ssn; */
static RuleMetaData rule16531service1 = 
{
    "service netbios-ssn"
};
//
//static RuleMetaData rule16531policy1 =
//{
//    "policy balanced-ips drop"
//};
//
//static RuleMetaData rule16531policy2 =
//{
//    "policy security-ips drop"
//};

static RuleMetaData rule16531policy3 =
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule16531metadata[] =
{
    &rule16531service1,
//    &rule16531policy1,
//    &rule16531policy2,
    &rule16531policy3,
    NULL
};

RuleOption *rule16531options[] =
{
    &rule16531option0,
    &rule16531option1,
    NULL
};

Rule rule16531 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "445", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       16531, /* sigid */
       11, /* revision */
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "NETBIOS SMB client TRANS response ring0 remote code execution attempt",     /* message */
       rule16531refs /* ptr to references */
       ,rule16531metadata
   },
   rule16531options, /* ptr to rule options */
   &rule16531eval, /* replace with NULL to use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule16531eval(void *p) {
    const uint8_t *cursor_normal = 0, *beg_of_payload, *end_of_payload;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_client;
    if (checkFlow(p, rule16531options[0]->option_u.flowFlags) > 0 ) {

        if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
            return RULE_NOMATCH;

        cursor_normal = beg_of_payload;

        //The while loop is for reassembled packets that have multiple SMB messages
        // content:"|FF|SMB2", payload raw, offset 4, depth 5, fast_pattern;
        while (contentMatch(p, rule16531options[1]->option_u.content, &cursor_normal) > 0) {

            uint32_t nb_len;
            uint16_t wc;
            uint16_t dataoffset;
            uint16_t datacount;
            uint16_t bcc;

            //Should be a NetBIOS header
            if ((cursor_normal - beg_of_payload) < 9)
                return RULE_NOMATCH;

            nb_len = *(cursor_normal-6);
            nb_len |= *(cursor_normal-7) << 8;
            nb_len |= *(cursor_normal-8) << 16;

            //Make sure enough data is there to check all necessary fields
            if (cursor_normal+44 > end_of_payload)
                return RULE_NOMATCH;

            //Extract Word Count
            wc = *(cursor_normal+27) << 1; // Someone's being clever multiplying by 2

            // XXX Have seen this with a word count of 0 - means no datacount or dataoffset
            // cursor_normal+44 should normally catch this but if there is another request
            // because of a reassembled packet, we'll get here.
            // This is just to avoid false positives
            if (wc == 0)
            {
                cursor_normal += 30;
                continue;
            }

            //Extract Data Count and Data Offset
            datacount = read_little_16(cursor_normal+40);
            dataoffset = read_little_16(cursor_normal+42);

            if (dataoffset == 0)
				return RULE_NOMATCH;

            //Check to see if there is enough space for the word count field
            //plus word count * 2 bytes, the two-byte bcc field.
            if ((cursor_normal + 30 + wc) > end_of_payload)
                return RULE_NOMATCH;

            //data offset should be always less than the NetBIOS length
            //If not, dataoffset is jacked, so alert
            if (nb_len < dataoffset)
                return RULE_MATCH;

            //Data is the last field in the payload section of the SMB trans response
            //It should be equal to NetBIOS length - dataoffset
            if ((nb_len - dataoffset) > datacount)
                return RULE_MATCH;

            cursor_normal += 28 + wc;

            //Extract bcc
            bcc = read_little_16_inc(cursor_normal);

            //Jump to the end of the data
            cursor_normal += bcc;
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule16531,
    NULL
};
*/



