/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

!!! XXX DOES NOT USE THE BUILT-IN DETECTION FUNCTIONS XXX !!!

alert udp $EXTERNAL_NET any -> $HOME_NET 1027:5000 (msg:"EXPLOIT Microsoft WINS arbitrary memory modification attempt"; content:"|00 00 00|"; depth:3; offset:1; byte_test:4,<,2,0,little; reference:cve,2008-1451; reference:url,technet.microsoft.com/en-us/security/bulletin/MS08-034; classtype:attempted-admin; sid:13826; rev:1;)

 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule13826eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
// content:"|00 00 00|", offset 1, depth 3; 
static ContentInfo rule13826content0 = 
{
    (uint8_t *) "|00 00 00|", /* pattern (now in snort content format) */
    3, /* depth */
    1, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13826option0 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13826content0
    }
};
/* byte_test:size 4, value 2, operator <, endian little; */
static ByteData rule13826byte_test1 = 
{
    4, /* size */
    CHECK_LT, /* operator */
    2, /* value */
    0, /* offset */
    0, /*multiplier */
    BYTE_LITTLE_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE /* flags */
};

static RuleOption rule13826option1 = 
{
    OPTION_TYPE_BYTE_TEST,
    {
        &rule13826byte_test1
    }
};

/* references for sid 13826 */
/* reference: cve "2008-1451"; */
static RuleReference rule13826ref1 = 
{
    "cve", /* type */
    "2008-1451" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS08-034"; */
static RuleReference rule13826ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-034" /* value */
};

static RuleReference *rule13826refs[] =
{
    &rule13826ref1,
    &rule13826ref2,
    NULL
};
/* metadata for sid 13826 */

static RuleMetaData *rule13826metadata[] =
{
    NULL
};
RuleOption *rule13826options[] =
{
    &rule13826option0,
    &rule13826option1,
    NULL
};

Rule rule13826 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_UDP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "1027:5000", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13826, /* sigid */
       6, /* revision */
   
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft WINS arbitrary memory modification attempt",     /* message */
       rule13826refs /* ptr to references */
       ,rule13826metadata
   },
   rule13826options, /* ptr to rule options */
   &rule13826eval, /* DO NOT use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule13826eval(void *p) {
    const uint8_t *cursor_normal = 0, *end_of_payload = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
   
    if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
        return RULE_NOMATCH;

    if((end_of_payload - cursor_normal) != 24)
        return RULE_NOMATCH;
 
    // content:"|00 00 00|", offset 1, depth 3;
    if (contentMatch(p, rule13826options[0]->option_u.content, &cursor_normal) > 0) {
        // byte_test:size 4, value 2, operator <, endian little;
        if (byteTest(p, rule13826options[1]->option_u.byte, cursor_normal) > 0) {
            return RULE_MATCH;
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13826,
    NULL
};
*/

