/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 *
 *
 * Okay, so we get pretty tricky in this one --
 *
 * Sid 15453 reuses all of sid 15009's structures except the one content match.  This
 * includes the flow check, which means that the options list for 15453 is a combination
 * of both rules.  
 * 
 * sid 15847 is a copy of sid 15453 except it runs on telnet port 23.
 *
 * All rules use the same reference table and almost the same metadata.  All of the
 * references and the metadata are at the top of the file for ease of maintenance.
 *
 * All three rules all peek and poke with the same challenge list.  This is how we get
 * cross-protocol detection.  This is made simpler by having all three rules simply
 * get to the point where a pointer is aimed at the uint64_t that is the challenge.
 *
 * When we store the value, we knowingly ignore the endianness of the machine.  It
 * doesn't matter since we're only comparing to ourselves.
 *
 */

#include <syslog.h>
#include <arpa/inet.h>
#include <string.h>

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util_base64-decode.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

// CHALLISTSIZE *must* be a power of 2 <= 256  (16, 32, 64, 128, 256)
// If CHALLISTSIZE is to be greater than 256, change the type of challenge_index
// to be uint16_t
#define CHALLISTSIZE 128
#define CHALINDEXMASK (CHALLISTSIZE - 1)

/* declare detection functions */
int rule15009eval(void *p);
int rule15124eval(void *p);
int rule15453eval(void *p);
int rule15847eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */

/* All of these are related.  Put all references up here at the top for ease
 * of maintenance and include in all of the rules.
*/
static RuleReference ruleSMBREFLECTIONref1 =
{
    "cve", /* type */
    "2008-4037" /* value */
};
static RuleReference ruleSMBREFLECTIONref2 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-068" /* value */
};
static RuleReference ruleSMBREFLECTIONref3 =
{
    "cve", /* type */
    "2008-3009" /* value */
};
static RuleReference ruleSMBREFLECTIONref4 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-076" /* value */
};
static RuleReference ruleSMBREFLECTIONref5 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-013" /* value */
};
static RuleReference ruleSMBREFLECTIONref6 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-014" /* value */
};
static RuleReference ruleSMBREFLECTIONref7 =
{
    "cve", /* type */
    "2009-0550" /* value */
};
static RuleReference ruleSMBREFLECTIONref8 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS09-042" /* value */
};
static RuleReference ruleSMBREFLECTIONref9 =
{
    "cve", /* type */
    "2009-1930" /* value */
};
static RuleReference ruleSMBREFLECTIONref10 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS10-012" /* value */
};
static RuleReference ruleSMBREFLECTIONref11 =
{
    "cve", /* type */
    "2010-0231" /* value */
};
static RuleReference ruleSMBREFLECTIONref12 =
{
    "cve", /* type */
    "2000-0834" /* value */
};
static RuleReference ruleSMBREFLECTIONref13 =
{
    "cve", /* type */
    "2015-0005" /* value */
};
static RuleReference ruleSMBREFLECTIONref14 =
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS15-027" /* value */
};


static RuleReference *ruleSMBREFLECTIONrefs[] =
{
    &ruleSMBREFLECTIONref1,
    &ruleSMBREFLECTIONref2,
    &ruleSMBREFLECTIONref3,
    &ruleSMBREFLECTIONref4,
    &ruleSMBREFLECTIONref5,
    &ruleSMBREFLECTIONref6,
    &ruleSMBREFLECTIONref7,
    &ruleSMBREFLECTIONref8,
    &ruleSMBREFLECTIONref9,
    &ruleSMBREFLECTIONref10,
    &ruleSMBREFLECTIONref11,
    &ruleSMBREFLECTIONref12,
    &ruleSMBREFLECTIONref13,
    &ruleSMBREFLECTIONref14,
    NULL
};


/* Let's do all of the metadata information up here, too. */
/* All policy info is the same */
static RuleMetaData ruleSMBREFLECTIONpolicy1 =
{
    "policy balanced-ips drop"
};

static RuleMetaData ruleSMBREFLECTIONpolicy2 =
{
    "policy security-ips drop"
};

static RuleMetaData ruleSMBREFLECTIONpolicy3 =
{
    "policy max-detect-ips drop"
};

/* But the service can change */
static RuleMetaData ruleSMBREFLECTIONservice_NETBIOS =
{
    "service netbios-ssn"
};
static RuleMetaData ruleSMBREFLECTIONservice_HTTP =
{
    "service http"
};
static RuleMetaData ruleSMBREFLECTIONservice_TELNET =
{
    "service telnet"
};

/* Metadata structures for rule structures */
static RuleMetaData *ruleSMBREFLECTIONmetadata_NETBIOS[] =
{
//    &ruleSMBREFLECTIONpolicy1,
//    &ruleSMBREFLECTIONpolicy2,
    &ruleSMBREFLECTIONservice_NETBIOS,
    &ruleSMBREFLECTIONpolicy3,
    NULL
};
static RuleMetaData *ruleSMBREFLECTIONmetadata_HTTP[] =
{
//    &ruleSMBREFLECTIONpolicy1,
//    &ruleSMBREFLECTIONpolicy2,
    &ruleSMBREFLECTIONservice_HTTP,
    &ruleSMBREFLECTIONpolicy3,
    NULL
};
static RuleMetaData *ruleSMBREFLECTIONmetadata_TELNET[] =
{
//    &ruleSMBREFLECTIONpolicy1,
//    &ruleSMBREFLECTIONpolicy2,
    &ruleSMBREFLECTIONservice_TELNET,
    &ruleSMBREFLECTIONpolicy3,
    NULL
};


/* Now, let's do the rest of the rule structures */

/* flow:established, to_client; */
static FlowFlags rule15009flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT/*|FLOW_IGNORE_REASSEMBLED*/
};

static RuleOption rule15009option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule15009flow0
    }
};
// content:"|FF|SMBr|00 00 00 00|"; 
static ContentInfo rule15009content1 = 
{
    (uint8_t *) "|FF|SMBr|00 00 00 00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15009option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule15009content1
    }
};

RuleOption *rule15009options[] =
{
    &rule15009option0,
    &rule15009option1,
    NULL
};

Rule rule15009 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "any", /* SRCIP     */
       "[139,445]", /* DSTPORT   */
       0, /* DIRECTION */
       "any", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       15009, /* sigid */
       22, /* revision */
   
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS possible SMB replay attempt - overlapping encryption keys detected",     /* message */
       ruleSMBREFLECTIONrefs /* ptr to references */
       ,ruleSMBREFLECTIONmetadata_NETBIOS
   },
   rule15009options, /* ptr to rule options */
   &rule15009eval, /* DO NOT use the built in detection function */
   0 /* am I initialized yet? */
};


// content: "NTLMSSP|00 02 00 00 00|";
static ContentInfo rule15453content1 =
{
    (uint8_t *) "NTLMSSP|00 02 00 00 00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED|CONTENT_FAST_PATTERN, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};


static RuleOption rule15453option1 =
{
    OPTION_TYPE_CONTENT,
    {
        &rule15453content1
    }
};

// content: "NTLMSSP|00 02 00 00 00|"; <-- same as previous but in raw buffer for telnet
static ContentInfo rule15453content2 =
{
    (uint8_t *) "NTLMSSP|00 02 00 00 00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_RAW, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};


static RuleOption rule15453option2 =
{
    OPTION_TYPE_CONTENT,
    {
        &rule15453content2
    }
};


RuleOption *rule15453options[] =
{
    &rule15009option0,
    &rule15453option1,
    &rule15453option2,
    NULL
};


Rule rule15453 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "any", /* SRCIP     */
       "[139,445]", /* DSTPORT   */
       0, /* DIRECTION */
       "any", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       15453, /* sigid */
       16, /* revision */
  
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS SMB replay attempt via NTLMSSP - overlapping encryption keys detected",     /* message */
       ruleSMBREFLECTIONrefs /* ptr to references */
       ,ruleSMBREFLECTIONmetadata_NETBIOS
   },
   rule15453options, /* ptr to rule options */
   &rule15453eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};

// content:"WWW-Authenticate|3A| NTLM", nocase; 
static ContentInfo rule15124content1 =
{
    (uint8_t *) "WWW-Authenticate|3A| NTLM", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_NOCASE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule15124option1 =
{
    OPTION_TYPE_CONTENT,
    {
        &rule15124content1
    }
};

RuleOption *rule15124options[] =
{
    &rule15009option0,
    &rule15124option1,
    NULL
};

Rule rule15124 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "any", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       15124, /* sigid */
       17, /* revision */

       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Web-based NTLM replay attack attempt",     /* message */
       ruleSMBREFLECTIONrefs /* ptr to references */
       ,ruleSMBREFLECTIONmetadata_HTTP
   },
   rule15124options, /* ptr to rule options */
   &rule15124eval, /* DO NOT use the built in detection function */
   0 /* am I initialized yet? */
};

/* rule15847 is a clone of rule15453, running on port 23 */
Rule rule15847 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "any", /* SRCIP     */
       "23", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       15847, /* sigid */
       14, /* revision */

       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Telnet-based NTLM replay attack attempt",     /* message */
       ruleSMBREFLECTIONrefs /* ptr to references */
       ,ruleSMBREFLECTIONmetadata_TELNET
   },
   rule15453options, /* ptr to rule options */
   &rule15847eval, /* DO NOT use the built in detection function */
   0 /* am I initialized yet? */
};



/* detection functions */
/* Round robin storage of the past 16 challenges seen on the network.
   This is global data that can be seen across streams.
*/
typedef struct {
   uint64_t challenge;
   uint32_t saddr;
   uint16_t sport;
} challenge_struct;

static challenge_struct challenge_list[CHALLISTSIZE];
static uint8_t challenge_index = 0;


/* check_challenge()
 * The packet pointer is just there for debugging.  Sure, it's a wasted instruction,
 * but this code is a big enough pain that it's worth having when things go wrong.
 *
 * The pointer goes directly to the new hash
 * 
 * Looks for a match, updates challenge list if appropriate
 * Returns RULE_MATCH/RULE_NOMATCH as appropriate.
*/
int check_challenge(SFSnortPacket *sp, uint64_t *input_ptr) {
   challenge_struct newchallenge;
   int i;

   if(!sp || !(sp->ip4_header) || !(sp->tcp_header))
      return RULE_NOMATCH;

   DEBUG_SO(char saddr[16]);
   DEBUG_SO(char daddr[16]);
   DEBUG_SO(char name[] = "check_challenge");

   // This typecast is okay because we never modify it or compare it to
   // anything no read the same way.  Endianness of the machine doesn't matter.
   newchallenge.challenge = *input_ptr; 
   newchallenge.saddr = sp->ip4_header->source.s_addr;
   newchallenge.sport = sp->src_port;

   if(newchallenge.challenge == 0) { // bypassing buggy test device
      return RULE_NOMATCH;
   }

   DEBUG_SO(strncpy(saddr, inet_ntoa(sp->ip4_header->source), 16));
   DEBUG_SO(strncpy(daddr, inet_ntoa(sp->ip4_header->destination), 16));
   DEBUG_SO(printf("%s: challenge: 0x%llx %s:%d -> %s:%d check:0x%04x(not used) reass(%d)\n", name, (unsigned long long)newchallenge.challenge, saddr, sp->src_port, daddr, sp->dst_port, sp->tcp_header->checksum, sp->flags & FLAG_REBUILT_STREAM));

   for(i = 0; i < CHALLISTSIZE; i++) {
      if(newchallenge.challenge == challenge_list[i].challenge) {
         DEBUG_SO(printf("found matching challenge\n"));
         // If challenge matches but the saddr and sport do not, alert
         // If challenge and tcp checksum both match, drop out so we don't
         // store the values twice
         if(newchallenge.saddr != challenge_list[i].saddr || newchallenge.sport != challenge_list[i].sport)
            return RULE_MATCH;
         else
            return RULE_NOMATCH;
      }
   }

   challenge_list[challenge_index & CHALINDEXMASK] = newchallenge;
   challenge_index++;

   return RULE_NOMATCH;
}


int rule15009eval(void *p) {
   const uint8_t *cursor_normal = 0, *beg_of_payload, *end_of_payload;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   DEBUG_SO(char name[] = "rule15009eval");
   DEBUG_SO(printf("%s: enter\n", name));

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;
    
   // flow:established, to_client;
   if(checkFlow(p, rule15009options[0]->option_u.flowFlags) <= 0 )
      return RULE_NOMATCH;

   DEBUG_SO(printf("%s: checkFlow() passed\n", name));

   // content:"|FF|SMBr|00 00 00 00|";
   if(contentMatch(p, rule15009options[1]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   DEBUG_SO(printf("%s: contentMatch(\"|FF|SMBr|00 00 00 00|\") passed\n", name));

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   if(cursor_normal + 68 >= end_of_payload)
      return RULE_NOMATCH;

   cursor_normal += 24;

   DEBUG_SO(printf("%s: DIALECT/MODE |%02x %02x %02x|\n", name, *(cursor_normal), *(cursor_normal+1), *(cursor_normal+2)));

   // Dialect Index: 3+ means greater than LANMAN2.1 
   if(*cursor_normal < 3 && *(cursor_normal + 1) == 0)
      return RULE_NOMATCH;

   // Want Security Mode: 0x03
   if(*(cursor_normal + 2) != 0x03)
      return RULE_NOMATCH;

   // Do not want Extended Security Mode
   if(*(cursor_normal + 22) && 0x80)
      return RULE_NOMATCH;

   cursor_normal += 36;

   return(check_challenge(sp, (uint64_t*)cursor_normal));
}


// XXX Detection is duplicated for 15847.  Be sure any mods here are reflected below.
int rule15453eval(void *p) {
   const uint8_t *cursor_normal = 0, *beg_of_payload, *end_of_payload;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   DEBUG_SO(char name[] = "rule15453eval");
   DEBUG_SO(printf("%s: enter\n", name));

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_client;
   if(checkFlow(p, rule15453options[0]->option_u.flowFlags) <= 0 )
      return RULE_NOMATCH;

   DEBUG_SO(printf("%s: checkFlow() passed\n", name));

   // content:"NTLMSSP|00 02 00 00 00|";
   if(contentMatch(p, rule15453options[1]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   DEBUG_SO(printf("%s: contentMatch(\"NTLMSSP|00 02 00 00 00|\") passed\n", name));

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   if(cursor_normal + 20 >= end_of_payload)
      return RULE_NOMATCH;

   cursor_normal += 12; 

   return(check_challenge(sp, (uint64_t*)cursor_normal));
}


// XXX Same detection as 15453 except uses RAW buffer.  Make sure the
// two functions are duplicated if modified.
int rule15847eval(void *p) {
   const uint8_t *cursor_raw = 0, *beg_of_payload, *end_of_payload;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   DEBUG_SO(char name[] = "rule15847eval");
   DEBUG_SO(printf("%s: enter\n", name));

   if(sp == NULL)
      return RULE_NOMATCH;

   // flow:established, to_client;
   if(checkFlow(p, rule15453options[0]->option_u.flowFlags) <= 0 )
      return RULE_NOMATCH;

   DEBUG_SO(printf("%s: checkFlow() passed\n", name));

   // content:"NTLMSSP|00 02 00 00 00|";  <-- RAW buffer for telnet control packets
   if(contentMatch(p, rule15453options[2]->option_u.content, &cursor_raw) <= 0)
      return RULE_NOMATCH;

   DEBUG_SO(printf("%s: contentMatch(\"NTLMSSP|00 02 00 00 00|\") passed\n", name));

   if(getBuffer(sp, CONTENT_BUF_RAW, &beg_of_payload, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   if(cursor_raw + 20 >= end_of_payload)
      return RULE_NOMATCH;

   cursor_raw += 12;

   return(check_challenge(sp, (uint64_t*)cursor_raw));
}


int rule15124eval(void *p) {
   const uint8_t *cursor_normal = 0, *beg_of_payload, *end_of_payload;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   // Base64 stuff
   uint8_t base64buf[256], decodedbuf[256];
   uint32_t inputchars, base64bytes, decodedbytes;

   DEBUG_SO(char name[] = "rule15124eval");
   DEBUG_SO(printf("%s: enter\n", name));

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_client;
   if(checkFlow(p, rule15124options[0]->option_u.flowFlags) <= 0 )
      return RULE_NOMATCH;

   // content:"WWW-Authenticate|3A| NTLM", nocase;
   if(contentMatch(p, rule15124options[1]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   // At this point, cursor should point to the start of the auth data
   // Note that technically, we could be at the initial server indicator that NTLM auth
   // is required, but our check below for minimum decoded bytes will keep us from
   // doing anything; unfold_header will simply return no data.
   // http://www.innovation.ch/personal/ronald/ntlm.html
   inputchars = (end_of_payload > cursor_normal + sizeof(base64buf)) ? sizeof(base64buf) : end_of_payload - cursor_normal;
   if(unfold_header(cursor_normal, inputchars, base64buf, sizeof(base64buf), &base64bytes) != 0)
      return RULE_NOMATCH;

   DEBUG_SO(printf("%s: Successfully unfolded header (%s)(%d)\n", name, base64buf, base64bytes));

   if(base64decode(base64buf, base64bytes, decodedbuf, sizeof(decodedbuf), &decodedbytes) < 0)
      return RULE_NOMATCH;

   DEBUG_SO(printf("%s: Successfully base64 decoded (%s)(%d)\n", name, decodedbuf, decodedbytes));

   // Now, decodedbuf should contain our NTLM Type-2 message.  Let's make sure, eh?
   if(decodedbytes < 32) // Not the full length, but we don't care
      return RULE_NOMATCH;

   if(memcmp(decodedbuf, "NTLMSSP\x00\x02\x00\x00\x00", 12))
      return RULE_NOMATCH;

   return(check_challenge(sp, (uint64_t*)(&(decodedbuf[24]))));
}

/*
Rule *rules[] = {
    &rule15009,
    &rule15124,
    &rule15453,
    &rule15847,
    NULL
};
*/

