/*
   XXX does not use built-in detection function! XXX

alert tcp $EXTERNAL_NET any -> $HOME_NET any (msg:"DOS Microsoft Windows TCP SACK invalid range denial of service attempt"; flow:established; flags:A; reference:cve,2010-0242; reference:url,technet.microsoft.com/en-us/security/bulletin/MS10-009; classtype:attempted-dos; sid:16408; rev:1;)
*/
/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

#include <time.h>

// This is for ignoring all possible reassembled packets, not just those covered by the
// FLOW_IGNORE_REASSEMBLED option to checkFlow.
#ifndef REASSEMBLED_PACKET_FLAGS
#define REASSEMBLED_PACKET_FLAGS (FLAG_REBUILT_STREAM|FLAG_SMB_SEG|FLAG_DCE_SEG|FLAG_DCE_FRAG|FLAG_SMB_TRANS)
#endif

//#define DEBUG 
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

typedef struct _AckCount {
    uint32_t ack;
    uint16_t total_count;
    time_t    timestamp;     // time when ack is first seen 
} AckCount;

/* declare detection functions */
int rule16408eval(void *p);

/* declare rule data structures */
/* flow:established; */
static FlowFlags rule16408flow0 = 
{
    FLOW_ESTABLISHED
};

static RuleOption rule16408option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule16408flow0
    }
};

// tcp_flags:ack;
static HdrOptCheck rule16408tcp_flags1 =
{
    TCP_HDR_FLAGS,
    CHECK_EQ,
    TCPHEADER_ACK,
    0,
    0
};

static RuleOption rule16408option1 =
{
    OPTION_TYPE_HDR_CHECK,
    {
        &rule16408tcp_flags1
    }
};

/* references for sid 16408 */
/* reference: cve "2010-0242"; */
static RuleReference rule16408ref1 = 
{
    "cve", /* type */
    "2010-0242" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS10-009"; */
static RuleReference rule16408ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS10-009" /* value */
};

static RuleReference *rule16408refs[] =
{
    &rule16408ref1,
    &rule16408ref2,
    NULL
};
/* metadata:; */


static RuleMetaData *rule16408metadata[] =
{
    NULL
};

RuleOption *rule16408options[] =
{
    &rule16408option0,
    &rule16408option1,
    NULL
};

Rule rule16408 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
   
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
   
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       16408, /* sigid */
       14, /* revision */
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft Windows TCP SACK invalid range denial of service attempt",     /* message */
       rule16408refs /* ptr to references */
       ,rule16408metadata
   },
   rule16408options, /* ptr to rule options */
   &rule16408eval, /* DO NOT use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule16408eval(void *p) {
    const uint8_t *cursor_normal = 0, *end_of_payload = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    uint8_t  option_kind;
    uint8_t  option_length;

    uint32_t ack;
    uint32_t sack_num;
    uint32_t diff;
    
    const uint8_t *end_of_options;
    const uint8_t *end_of_sack;

    AckCount *ackcount;

    if((sp == NULL) || (sp->stream_session_ptr == NULL))
        return RULE_NOMATCH;
        
    /* Don't look at application layer reassembled packets - we've already
     * seen and evalulated the packet off the wire */
    if (sp->flags & REASSEMBLED_PACKET_FLAGS)
        return RULE_NOMATCH;

    /*
     * NOTE: sp->payload_size can be set to 0 (even if there is payload data),
     * if packets go through http_inspect preprocessor (due to flow_depth handling)
     *
     * If there is any data after TCP header, it is not a duplicate ACK */     
     if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
         return RULE_NOMATCH;

    DEBUG_SO(printf("payload size %d\n", sp->ip_payload_size - (20 + sp->tcp_options_length));)
    if(((end_of_payload - cursor_normal) != 0) || (((end_of_payload - cursor_normal) - (20 + sp->tcp_options_length)) != 0)) 
        return RULE_NOMATCH;
        
    // flow:established;
    if (checkFlow(p, rule16408options[0]->option_u.flowFlags) <= 0)
        return RULE_NOMATCH;
    
    // tcp_flags:ack;
    if (checkHdrOpt(p, rule16408options[1]->option_u.hdrData) <= 0)
        return RULE_NOMATCH;

    if (sp->tcp_header == NULL)
        return RULE_NOMATCH;

    ack = ntohl(sp->tcp_header->acknowledgement);

    /* If there are 3 ACKs after SACK whose left or right value is not in the valid range, it is a malicious traffic */
#ifndef BEFORE_2091300
    getRuleData(sp, &(rule16408.info), (void*)(&ackcount), NULL);
#else
    ackcount = (AckCount *)getRuleData(sp, (uint32_t)rule16408.info.sigID);
#endif

    if (ackcount != NULL)
    {
        if (ackcount->ack == ack)
        {
            DEBUG_SO(printf("difftime(time(NULL), ackcount->timestamp)): %u\n", (uint32_t)difftime(time(NULL), ackcount->timestamp));)
                
            if (difftime(time(NULL), ackcount->timestamp) < 2) // to check if ACK is for fast retransmission, to avoid FPs
            {
                ackcount->total_count++;            
                if (ackcount->total_count >= 3) // ACK with SACK and 3 following ACKs
                {
                    DEBUG_SO(printf("3 ACKs (%08x) has been sent for fast retransmission\n", ack);)
                    return RULE_MATCH;
                }
            }            

            return RULE_NOMATCH;
        } else
        {
           ackcount->ack = 0;
        }
    }
   
    // If TCP options include Selective Acknowledgement, tcp options length should be at least 10
    if (sp->tcp_options_length < 10) 
        return RULE_NOMATCH;

    if (sp->tcp_options_data == NULL)
        return RULE_NOMATCH;

    cursor_normal = sp->tcp_options_data;
    end_of_options = cursor_normal + sp->tcp_options_length;
    
    // Parse TCP options
    while (cursor_normal + 6 <= end_of_options)
    {
        option_kind = *cursor_normal++;
        DEBUG_SO(printf("option kind: %02x\n", option_kind);)

        switch(option_kind)
        {
            case 0: // End of Option List
            case 1: // No-Operation
                // There is no length field
                break;
                
            case 5:
                option_length = *cursor_normal++;
                DEBUG_SO(printf("option length: %02x\n", option_length);)
                    
                end_of_sack = cursor_normal + option_length;
        
                if (end_of_options < end_of_sack)
                    end_of_sack = end_of_options;
        
                while (cursor_normal + 4 <= end_of_sack)
                {            
                    sack_num = read_big_32(cursor_normal);
                    DEBUG_SO(printf("sack_num: %08x\n", sack_num);)                
                    cursor_normal += 4;
            
                    /* technically, the spec says this is in SACK pairs,
                     * but we only care if one or the other are out of range
                     * so we read them one at a time for speed.
                    */
                        
                    /* We need to cover a wrapped sequence number case
                       so that integer underflow is not an issue */
                    diff = sack_num - ack;
                    if (diff >= 0x80000000 && diff < 0xC0000000) // 2GB ~ 3GB
                    {
                        DEBUG_SO(printf("diff of sack_num and ack: %08x\n", sack_num - ack);)

                        if (ackcount == NULL)
                        {
                            ackcount = (AckCount *)allocRuleData(sizeof(AckCount));
                            if (ackcount == NULL)
                               return RULE_NOMATCH;

#ifndef BEFORE_2091300
                            if(storeRuleData(sp, &(rule16408.info), ackcount, NULL) < 0)
#else
                            if(storeRuleData(sp, ackcount, rule16408.info.sigID, &freeRuleData) < 0)
#endif
                            {
                               freeRuleData(ackcount);
                               return RULE_NOMATCH;
                            }
                        }                      

                        ackcount->ack = ack;
                        ackcount->total_count = 0;
                        ackcount->timestamp   = time(NULL);
                        
                        return RULE_NOMATCH;
                    }
                }
                break;
                
            default:        
                option_length = *cursor_normal++;
                DEBUG_SO(printf("option length: %02x\n", option_length);)
                cursor_normal += option_length;
                break;
                
        } // end of switch(option_kind)
    } // end of while
    
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule16408,
    NULL
};
*/
