/* Does not use built-in detection function.
*/


/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG
#ifdef DEBUG
    #define DEBUG_SO(code) code
#else
    #define DEBUG_SO(code)
#endif

/* declare detection functions */
int rule23039eval(void *p);
int rule23040eval(void *p);
uint8_t detectDNSloop(SFSnortPacket *sp, const uint8_t *cursor_normal);

/* declare rule data structures */

/* flow:to_server; */
static FlowFlags rule23039flow0 =
{
    FLOW_TO_SERVER
};

static RuleOption rule23039option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule23039flow0
    }
};

// UDP ContnetInfo
// content:"|00 01 00 00 00 00 00 00|", offset 4, depth 8, fast_pattern; 
static ContentInfo rule23039content1 = 
{
    (uint8_t *) "|00 01 00 00 00 00|", /* pattern (now in snort content format) */
    6, /* depth */
    4, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule23039option1 =
{
    OPTION_TYPE_CONTENT,
    {
        &rule23039content1
    }
};

/* declare rule data structures */
/* flow:established, to_server; */
static FlowFlags rule23040flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule23040option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {   
        &rule23040flow0
    }   
};

// TCP ContentInfo
// content:"|00 01 00 00 00 00 00 00|", offset 6, depth 8, fast_pattern; 
static ContentInfo rule23040content1 =
{
    (uint8_t *) "|00 01 00 00 00 00|", /* pattern (now in snort content format) */
    6, /* depth */
    6, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule23040option1 = 
{
    OPTION_TYPE_CONTENT,
    {   
        &rule23040content1
    }   
};

/* references for sid 23039 */
/* reference: bugtraq "22606"; */
static RuleReference rule23039ref1 = 
{
    "bugtraq", /* type */
    "22606" /* value */
};

/* reference: cve "2007-1030"; */
static RuleReference rule23039ref2 = 
{
    "cve", /* type */
    "2007-1030" /* value */
};

/* reference: url "osvdb.org/33228"; */
static RuleReference rule23039ref3 = 
{
    "url", /* type */
    "osvdb.org/33228" /* value */
};

static RuleReference *rule23039refs[] =
{
    &rule23039ref1,
    &rule23039ref2,
    &rule23039ref3,
    NULL
};
/* metadata for sid 23039 */
/* metadata:service dns, policy balanced-ips drop, policy security-ips drop; */
static RuleMetaData rule23039service1 = 
{
    "service dns"
};


static RuleMetaData rule23039policy1 = 
{
    "policy security-ips drop"
};

static RuleMetaData rule23039policy2 = 
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule23039metadata[] =
{
    &rule23039service1,
    &rule23039policy1,
    &rule23039policy2,
    NULL
};

RuleOption *rule23039options[] =
{
    &rule23039option0,
    &rule23039option1,
    NULL
};

RuleOption *rule23040options[] =
{
    &rule23040option0,
    &rule23040option1,
    NULL
};

Rule rule23039 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_UDP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "[53,5533]", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       23039, /* sigid */
       4, /* revision */
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "PROTOCOL-DNS Multiple vendor DNS message decompression denial of service attempt",     /* message */
       rule23039refs /* ptr to references */
       ,rule23039metadata
   },
   rule23039options, /* ptr to rule options */
   &rule23039eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};

Rule rule23040 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "[53,5533]", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid */
       23040, /* sigid */
       4, /* revision */
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "PROTOCOL-DNS Multiple vendor DNS message decompression denial of service attempt",     /* message */
       rule23039refs /* ptr to references */
       ,rule23039metadata
   },
   rule23040options, /* ptr to rule options */
   &rule23040eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
// #if 0 // Don't compile the detection functions if they're not used
int rule23039eval(void *p) {
    const uint8_t  *cursor_normal  = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;

    // flow:to_server;
    if(checkFlow(p, rule23039options[0]->option_u.flowFlags) <= 0 )
        return RULE_NOMATCH;
   
    // content:"|00 01 00 00 00 00|", offset 4, depth 6, fast_pattern;
    if(contentMatch( p, rule23039options[1]->option_u.content, &cursor_normal ) <= 0)
        return RULE_NOMATCH;

    // The last |00| in the match above drops the cursor at the beginning of the first query,
    //      12 bytes from the beginning of the payload.  If the first 2 bits are set on this byte,
    //      it means we're looking at a pointer.  In that event, we'll go ahead and flag it, because
    //      we've already verified that there is only one query.

    return detectDNSloop(sp, cursor_normal + 2 /*skip addl record field */ );
}

int rule23040eval(void *p) {
    const uint8_t *cursor_normal = 0;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_server;
    if(checkFlow(p, rule23040options[0]->option_u.flowFlags) <= 0 ) 
        return RULE_NOMATCH;

    // content:"|00 01 00 00 00 00|", offset 6, depth 6, fast_pattern;
    if(contentMatch(p, rule23040options[1]->option_u.content, &cursor_normal) <= 0)  
        return RULE_NOMATCH;

    return detectDNSloop( sp, cursor_normal + 2 /*skip addl record field */ );
}

uint8_t detectDNSloop( SFSnortPacket *sp, const uint8_t *cursor_normal )
{
    const uint8_t *beg_of_payload = 0;
    const uint8_t *end_of_payload = 0;

    if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
        return RULE_NOMATCH;

    while((cursor_normal < end_of_payload) && (*cursor_normal != 0x00))
    {
       // Indicator of malice is "dns compression" aka "a pointer" within the
       // dns query.  This is normal for responses but not in a query.
       if((*cursor_normal & 0xc0) == 0xc0)
          return RULE_MATCH;

       cursor_normal += *cursor_normal;
       cursor_normal++;
    }

    return RULE_NOMATCH;
}


// #endif // 0 Don't compile the detection functions if they're not used
/*
Rule *rules[] = {
    &rule23039,
    NULL
};
*/
