/*
 * VRT RULES
 * 
 * Copyright (C) 2007 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

/* declare detection functions */
int ruleCITRIX_METAFRAME_BOeval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags ruleCITRIX_METAFRAME_BOflow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption ruleCITRIX_METAFRAME_BOoption0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &ruleCITRIX_METAFRAME_BOflow0
    }
};
// content:"A|80 00 00 02|", offset 28, depth 5; 
static ContentInfo ruleCITRIX_METAFRAME_BOcontent1 = 
{
    (uint8_t *)"A|80 00 00 02|", /* pattern (now in snort content format) */
    5, /* depth */
    28, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption ruleCITRIX_METAFRAME_BOoption1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &ruleCITRIX_METAFRAME_BOcontent1
    }
};
/* byte_test:size 4, value 16, operator <, endian little; */
static ByteData ruleCITRIX_METAFRAME_BObyte_test2 = 
{
    4, /* size */
    CHECK_LT, /* operator */
    16, /* value */
    4, /* offset */
    0, /*multiplier */
    BYTE_LITTLE_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE /* flags */
};

static RuleOption ruleCITRIX_METAFRAME_BOoption2 = 
{
    OPTION_TYPE_BYTE_TEST,
    {
        &ruleCITRIX_METAFRAME_BObyte_test2
    }
};

/* references for sid 64892 */
/* reference: bugtraq "20986"; */
static RuleReference ruleCITRIX_METAFRAME_BOref1 = 
{
    "bugtraq", /* type */
    "20986" /* value */
};

/* reference: url "support.citrix.com/article/CTX111186"; */
static RuleReference ruleCITRIX_METAFRAME_BOref2 = 
{
    "url", /* type */
    "support.citrix.com/article/CTX111186" /* value */
};

/* reference: cve "i2006-5821"; */
static RuleReference ruleCITRIX_METAFRAME_BOref3 =
{
    "cve", /* type */
    "2006-5821" /* value */
};

static RuleReference *ruleCITRIX_METAFRAME_BOrefs[] =
{
    &ruleCITRIX_METAFRAME_BOref1,
    &ruleCITRIX_METAFRAME_BOref2,
    &ruleCITRIX_METAFRAME_BOref3,
    NULL
};

/* metadata for sid 13417 */
/* metadata:policy max-detect-ips drop; */

static RuleMetaData ruleCITRIX_METAFRAME_BOpolicy1 =
{
   "policy max-detect-ips drop"
};

static RuleMetaData *ruleCITRIX_METAFRAME_BOmetadata[] =
{
   &ruleCITRIX_METAFRAME_BOpolicy1,
   NULL
};

RuleOption *ruleCITRIX_METAFRAME_BOoptions[] =
{
    &ruleCITRIX_METAFRAME_BOoption0,
    &ruleCITRIX_METAFRAME_BOoption1,
    &ruleCITRIX_METAFRAME_BOoption2,
    NULL
};

Rule ruleCITRIX_METAFRAME_BO = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "2513", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13417, /* sigid eeb98951-131e-4397-a1bd-a2f5ccebaa04 */
       5, /* revision 5851b1b8-2651-4de8-9287-a2737fdb2629 */
   
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SERVER-OTHER Citrix MetaFrame IMA authentication processing buffer overflow attempt",     /* message */
       ruleCITRIX_METAFRAME_BOrefs, /* ptr to references */
       ruleCITRIX_METAFRAME_BOmetadata /* ptr to metadata */
   },
   ruleCITRIX_METAFRAME_BOoptions, /* ptr to rule options */
   &ruleCITRIX_METAFRAME_BOeval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int ruleCITRIX_METAFRAME_BOeval(void *p) {
    const uint8_t *cursor_normal = 0, *beg_of_payload, *end_of_payload;

    const uint8_t *cursor_extract = 0;
    uint32_t event_data_length, description_length, encr_data_length;

    SFSnortPacket *sp = (SFSnortPacket *) p;

    // flow:established, to_server;
    if (checkFlow(p, ruleCITRIX_METAFRAME_BOoptions[0]->option_u.flowFlags) > 0 ) {

        // content:"A|80 00 00 02|", offset 28, depth 5;
        if (contentMatch(p, ruleCITRIX_METAFRAME_BOoptions[1]->option_u.content, &cursor_normal) > 0) {

            // byte_test:size 4, value 16, operator <, offset 4, endian little;
            if (byteTest(p, ruleCITRIX_METAFRAME_BOoptions[2]->option_u.byte, cursor_normal) > 0) {

                if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
                     return RULE_NOMATCH;

                if((end_of_payload - beg_of_payload) < 0x28)
                   return RULE_NOMATCH;


                // Extract Event Data Length ( 4 bytes little endian )
                cursor_extract = &(beg_of_payload[0x0008]);
                event_data_length  = (*cursor_extract++) & 0xFF;
                event_data_length |= ((*cursor_extract++) & 0xFF) << 8;
                event_data_length |= ((*cursor_extract++) & 0xFF) << 16;
                event_data_length |= ((*cursor_extract++) & 0xFF) << 24;

                // Extract Description Length ( 2 bytes little endian )
                cursor_extract = &(beg_of_payload[0x0022]);
                description_length  = (*cursor_extract++) & 0xFF;
                description_length |= ((*cursor_extract++) & 0xFF) << 8;

		// extract Encrypted Data Length ( 4 bytes little endian )
                cursor_extract = &(beg_of_payload[0x00024]);
                encr_data_length  = (*cursor_extract++) & 0xFF;
                encr_data_length |= ((*cursor_extract++) & 0xFF) << 8;
                encr_data_length |= ((*cursor_extract++) & 0xFF) << 16;
                encr_data_length |= ((*cursor_extract++) & 0xFF) << 24;

                if(description_length + encr_data_length > event_data_length)
                   return RULE_MATCH;
            }
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &ruleCITRIX_METAFRAME_BO,
    NULL
};
*/
