/* XXX DOES NOT USE BUILT-IN DETECTION FUNCTION! XXX
alert tcp $EXTERNAL_NET any -> $HOME_NET [389,9833] (msg:"EXPLOIT Sun Directory Server LDAP denial of service attempt"; flow:to_server,established; content:"|30|"; depth:1; reference:cve,2006-0647; reference:url,lists.immunitysec.com/pipermail/dailydave/2006-February/002914.html; classtype:attempted-dos; sid:18101;)
*/
/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util_ber.h"

/* declare detection functions */
int rule18101eval(void *p);

/* declare rule data structures */
/* flow:established, to_server; */
static FlowFlags rule18101flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule18101option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule18101flow0
    }
};
// content:"0", depth 1, fast_pattern; 
static ContentInfo rule18101content1 = 
{
    (uint8_t *) "0", /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule18101option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule18101content1
    }
};

/* references for sid 18101 */
/* reference: cve "2006-0647"; */
static RuleReference rule18101ref1 = 
{
    "cve", /* type */
    "2006-0647" /* value */
};

/* reference: url "lists.immunitysec.com/pipermail/dailydave/2006-February/002914.html"; */
static RuleReference rule18101ref2 = 
{
    "url", /* type */
    "lists.immunitysec.com/pipermail/dailydave/2006-February/002914.html" /* value */
};

static RuleReference *rule18101refs[] =
{
    &rule18101ref1,
    &rule18101ref2,
    NULL
};
/* metadata for sid 18101 */
/* metadata:; */
static RuleMetaData rule18101service1 =
{
    "service ldap"
};

static RuleMetaData rule18101policy1 =
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule18101metadata[] =
{
    &rule18101service1,
    &rule18101policy1,
    NULL
};

RuleOption *rule18101options[] =
{
    &rule18101option0,
    &rule18101option1,
    NULL
};

Rule rule18101 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "[389,9833]", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       18101, /* sigid */
       4, /* revision */
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SERVER-OTHER Sun Directory Server LDAP denial of service attempt",     /* message */
       rule18101refs /* ptr to references */
       ,rule18101metadata
   },
   rule18101options, /* ptr to rule options */
   &rule18101eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
// #if 0 // Don't compile the detection functions if they're not used
int rule18101eval(void *p) {
   const uint8_t *cursor_normal = 0;
   SFSnortPacket *sp = (SFSnortPacket *) p;
   const uint8_t *end_of_payload;

   BER_ELEMENT ber_element;

   if(sp == NULL)
      return RULE_NOMATCH;
    
   // flow:established, to_server;
   if(checkFlow(p, rule18101options[0]->option_u.flowFlags) <= 0 )
      return RULE_NOMATCH;

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   BER_DATA(0x30);
   BER_SKIP(0x02);

   if(ber_get_element(sp, cursor_normal, &ber_element) < 0)
      return RULE_NOMATCH;

   // Exploit condition is SearchRequest (0x63) or ModifyDNRequest (0x6c) with
   // large size.  We're going with 1000 as a max size, apparently.
   if(ber_element.data_len > 1000 && (ber_element.type == 0x63 || ber_element.type == 0x6c))
      return RULE_MATCH;

   return RULE_NOMATCH;
}
// #endif // 0 Don't compile the detection functions if they're not used
/*
Rule *rules[] = {
    &rule18101,
    NULL
};
*/
